<?php 
if( !function_exists('ftc_product_deals_slider_shortcode') ){
	function ftc_product_deals_slider_shortcode($atts, $content = null){

		extract(shortcode_atts(array(
				'title' 				=> ''
				,'layout' 				=> 'grid'
				,'columns' 				=> 4
				,'per_page' 			=> 3
				,'product_cats'			=> ''
				,'product_type'			=> 'sale'
				,'show_counter'			=> 1
				,'counter_position'		=> 'bottom' /* bottom - on-thumbnail */
				,'gallery_position'		=> 'bottom-out' /* bottom out line */
				,'show_image' 			=> 1
				,'show_gallery' 		=> 1
				,'show_title' 			=> 1
				,'show_sku' 			=> 0
				,'show_price' 			=> 1
				,'show_short_desc'  	=> 0
				,'show_rating' 			=> 1
				,'show_label' 			=> 1	
				,'show_categories'		=> 0	
				,'show_add_to_cart' 	=> 1
				,'show_nav'				=> 1
				,'auto_play'			=> 1
				,'margin'				=> 20
				,'desksmall_items' => '1'
                ,'tablet_items'      => '1'
                ,'tabletmini_items' => '1'
                ,'mobile_items' => '1'
                ,'mobilesmall_items' => '1'
			), $atts));			

			if ( !class_exists('WooCommerce') ){
				return;
			}
			
			if( $layout == 'list' ){
				$counter_position = 'bottom';
			}
			
			add_filter('ftc_loop_product_thumbnail', 'ftc_product_deals_thumbnail_filter', 10);
			
			if( $layout == 'list' && $show_short_desc ){
				add_action('woocommerce_after_shop_loop_item', 'wibar_template_loop_short_description', 65);
				$show_short_desc = 0;
			}
			
			if( $show_counter ){
				if( $counter_position == 'bottom' ){
					add_action('woocommerce_after_shop_loop_item', 'ftc_template_loop_time_deals', 65);			
				}
				else{
					add_action('woocommerce_after_shop_loop_item_title', 'ftc_template_loop_time_deals', 99);
				}
			}
                if( $show_gallery ){
				if( $counter_position == 'bottom-out' ){
					add_action('ftc_after_shop_loop_item', 'ftc_template_loop_thumb_list', 999);			
				}
				else{
					add_action('woocommerce_after_shop_loop_item_title', 'ftc_template_loop_thumb_list', 999);
				}
                        }
			/* Remove hook */
			$options = array(
					'show_image'		=> $show_image
					,'show_label'		=> $show_label
					,'show_title'		=> $show_title
					,'show_sku'			=> $show_sku
					,'show_price'		=> $show_price
					,'show_short_desc'	=> $show_short_desc
					,'show_categories'	=> $show_categories
					,'show_rating'		=> $show_rating
					,'show_add_to_cart'	=> $show_add_to_cart
				);
			ftc_remove_product_hooks_shortcode( $options );

			$args = array(
				'post_type'				=> array('product', 'product_variation')
				,'post_status' 			=> 'publish'
				,'ignore_sticky_posts'	=> 1
				,'posts_per_page' 		=> -1
				,'orderby' 				=> 'date'
				,'order' 				=> 'desc'
				,'meta_query' 			=> WC()->query->get_meta_query()
				,'tax_query'           	=> WC()->query->get_tax_query()
			);

			ftc_filter_product_by_product_type($args, $product_type);
			
			$array_product_cats = array();

			$product_cats = str_replace(' ', '', $product_cats);
			if( strlen($product_cats) > 0 ){
				$array_product_cats = explode(',', $product_cats);
			}			

			ob_start();
			global $woocommerce_loop, $post, $product;
			if( (int)$columns <= 0 ){
				$columns = 5;
			}
			$old_woocommerce_loop_columns = $woocommerce_loop['columns'];
			$woocommerce_loop['columns'] = $columns;
			
			$product_ids_on_sale = array();
			
			if( $product_type == 'top_rated' ){
				add_filter('posts_clauses', array(WC()->query, 'order_by_rating_post_clauses'));
			}
			
			$products = new WP_Query( $args );

			if( $product_type == 'top_rated' ){
				remove_filter('posts_clauses', array(WC()->query, 'order_by_rating_post_clauses'));	
			}
			
			if( $products->have_posts() ){
				while( $products->have_posts() ){
					$products->the_post();
					if( $post->post_type == 'product' ){
						if( in_array( get_post_meta($post->ID, '_visibility', true), array('catalog', 'visible') ) ){
							if( !empty($array_product_cats) ){
								$field_name = is_numeric($array_product_cats[0])?'ids':'slug';
								$post_terms = wp_get_post_terms($post->ID, 'product_cat', array('fields' => $field_name));
								if( is_array($post_terms) ){
									$array_intersect = array_intersect($post_terms, $array_product_cats);
									if( !empty($array_intersect) ){
										$product_ids_on_sale[] = $post->ID;
									}
								}
							}
							else{
								$product_ids_on_sale[] = $post->ID;
							}
						}
					}
					else{ /* Variation product */
						$post_parent_id = $post->post_parent;
						if( in_array( get_post_meta($post_parent_id, '_visibility', true), array('catalog', 'visible') ) ){
							if( !empty($array_product_cats) ){
								$field_name = is_numeric($array_product_cats[0])?'ids':'slug';
								$post_terms = wp_get_post_terms($post_parent_id, 'product_cat', array('fields' => $field_name));
								if( is_array($post_terms) ){
									$array_intersect = array_intersect($post_terms, $array_product_cats);
									if( !empty($array_intersect) ){
										$product_ids_on_sale[] = $post_parent_id;
									}
								}
							}
							else{
								$product_ids_on_sale[] = $post_parent_id;
							}
						}
					}
				}
			}
			$product_ids_on_sale = array_unique($product_ids_on_sale);
			$product_ids_on_sale = array_slice($product_ids_on_sale, 0, $per_page);
			
			if( count($product_ids_on_sale) == 0 ){
				$product_ids_on_sale = array(0);
			}
			
			$args = array(
				'post_type'				=> 'product'
				,'post_status' 			=> 'publish'
				,'ignore_sticky_posts'	=> 1
				,'posts_per_page' 		=> -1
				,'orderby' 				=> 'date'
				,'order' 				=> 'desc'
				,'post__in'				=> $product_ids_on_sale
			);
			
			ftc_filter_product_by_product_type($args, $product_type);
			
			if( $product_type == 'top_rated' ){
				add_filter('posts_clauses', array(WC()->query, 'order_by_rating_post_clauses'));
			}
			
			$products = new WP_Query($args);
			
			if( $product_type == 'top_rated' ){
				remove_filter('posts_clauses', array(WC()->query, 'order_by_rating_post_clauses'));	
			}
			
			$is_slider = ( isset($products->post_count) && $products->post_count > 1 )?true:false;
			
			if( $products->have_posts() ): 
				$classes = array();
				$classes[] = $layout;
				
				$data_attr = array();
				$data_attr[] = 'data-nav="'.esc_attr($show_nav).'"';
				$data_attr[] = 'data-autoplay="'.esc_attr($auto_play).'"';
				$data_attr[] = 'data-margin="'.esc_attr($margin).'"';
				$data_attr[] = 'data-columns="'.esc_attr($columns).'"';
				$data_attr[] = 'data-slider="'.$is_slider.'"';
                $data_attr[] = 'data-desksmall_items="'.$desksmall_items.'"';
                $data_attr[] = 'data-tablet_items="'.$tablet_items.'"';
                $data_attr[] = 'data-tabletmini_items="'.$tabletmini_items.'"';
                $data_attr[] = 'data-mobile_items="'.$mobile_items.'"';
                $data_attr[] = 'data-mobilesmall_items="'.$mobilesmall_items.'"';
				?>
				<div class="ftc-product-time-deal ftc-slider <?php echo esc_attr( implode(' ', $classes) ); ?>" <?php echo implode(' ', $data_attr); ?>>
					<div class="header-title">
						<?php if( strlen($title) > 0 ): ?>
                                            <h3 class="title_sub"><span><?php echo esc_html($title); ?></span></h3>
						<?php endif; ?>
					</div>
					<div class="meta-slider <?php echo ($is_slider)?'loading':''; ?>">
						<?php woocommerce_product_loop_start(); ?>				

						<?php while( $products->have_posts() ): $products->the_post(); ?>
							<?php wc_get_template_part( 'content', 'product' ); ?>							
						<?php endwhile; ?>			

						<?php woocommerce_product_loop_end(); ?>
					</div>
				</div>
				<?php
			endif;
			
			wp_reset_postdata();			

			/* restore hooks */
			remove_filter('ftc_loop_product_thumbnail', 'ftc_product_deals_thumbnail_filter', 10);
			
			if( $layout == 'list' ){
				remove_action('woocommerce_after_shop_loop_item', 'wibar_template_loop_short_description', 65);
			}
			
			if( $show_counter ){
				if( $counter_position == 'bottom' ){
					remove_action('woocommerce_after_shop_loop_item', 'ftc_template_loop_time_deals', 65);			
				}
				else{
					remove_action('woocommerce_after_shop_loop_item_title', 'ftc_template_loop_time_deals', 99);
				}
			}
                        
                        if( $show_gallery ){
				if( $counter_position == 'bottom-out' ){
					remove_action('ftc_after_shop_loop_item', 'ftc_template_loop_thumb_list', 999);			
				}
				else{
					remove_action('woocommerce_after_shop_loop_item_title', 'ftc_template_loop_thumb_list', 999);
				}
                        }

			ftc_restore_product_hooks_shortcode();

			$woocommerce_loop['columns'] = $old_woocommerce_loop_columns;
			
			return '<div class="woocommerce">' . ob_get_clean() . '</div>';
	}
}
add_shortcode('ftc_product_deals_slider', 'ftc_product_deals_slider_shortcode');


 ?>