<?php
/* * * Tiny account ** */
if (!function_exists('wibar_tiny_account')) {

    function wibar_tiny_account() {
        global $wp;
        $login_url = '#';
        $register_url = '#';
        $profile_url = '#';
        $logout_url = wp_logout_url(get_permalink());

        if (wibar_has_woocommerce()) { /* Active woocommerce */
            $myaccount_page_id = get_option('woocommerce_myaccount_page_id');
            if ($myaccount_page_id) {
                $login_url = get_permalink($myaccount_page_id);
                $register_url = $login_url;
                $profile_url = $login_url;
            }
        } else {
            $login_url = wp_login_url();
            $register_url = wp_registration_url();
            $profile_url = admin_url('profile.php');
        }

        $_user_logged = is_user_logged_in();
        ob_start();
        ?>
        <div class="ftc-account">
            <div class="ftc_login">
                <?php if (!$_user_logged): ?>
                    <a  class="login" href="<?php echo esc_url($login_url); ?>" title="<?php echo esc_html_e('Login', 'wibar'); ?>"><span><?php echo esc_html__('Login', 'wibar'); ?></span></a>

                    <a class="ftc_sign_up" href="<?php echo esc_url($register_url); ?>" title="<?php echo esc_html_e('Create New Account', 'wibar'); ?>"><span><?php echo esc_html__('Sign up', 'wibar'); ?></span></a>
                    <?php else: ?>
                        <a class="my-account" href="<?php echo esc_url($profile_url); ?>" title="<?php echo esc_html_e('My Account', 'wibar'); ?>"><span><?php echo esc_html__('My Account', 'wibar'); ?></span></a> 
                        <a class="log-out" href="<?php echo esc_url($logout_url); ?>" title="<?php echo esc_html_e('Logout', 'wibar'); ?>"><span><?php echo esc_html__('Logout', 'wibar'); ?></span></a>
                    <?php endif; ?>
                </div>
                <?php if (!$_user_logged): ?>
                    <div class="ftc_account_form dropdown-container">
                        <form name="ftc-login-form" class="ftc-login-form" action="<?php echo esc_url(wp_login_url()); ?>" method="post">

                            <p class="login-username">
                                <label><?php echo esc_html__('Username', 'wibar'); ?></label>
                                <input type="text" name="log" class="input" value="" size="20" autocomplete="off">
                            </p>
                            <p class="login-password">
                                <label><?php echo esc_html__('Password', 'wibar'); ?></label>
                                <input type="password" name="pwd" class="input" value="" size="20">
                            </p>

                            <p class="login-submit">
                                <input type="submit" name="wp-submit" class="button-secondary button" value="<?php echo esc_html_e('Login', 'wibar'); ?>">
                                <input type="hidden" name="redirect_to" value="<?php echo esc_attr(home_url( $wp->request ))?>" >
                            </p>

                        </form>

                        <p class="ftc_forgot_pass"><a href="<?php echo esc_url(wp_lostpassword_url()); ?>" title="<?php echo esc_html_e('Forgot Your Password?', 'wibar'); ?>"><?php echo esc_html__('Forgot Your Password?', 'wibar'); ?></a></p>
                    </div>
                <?php endif; ?>
            </div>

            <?php
            return ob_get_clean();
        }

    }

    /* *  Tiny Cart * */
    if (!function_exists('wibar_tiny_cart')) {

        function wibar_tiny_cart() {
            if (!wibar_has_woocommerce()) {
                return '';
            }
            global $smof_data;
            ob_start();
            ?>
            <div class="ftc-tini-cart">
                <div class="cart-item">
                    <a class="ftc-cart-tini <?php if($smof_data['ftc_cart_layout'] == 'off-canvas') {
                        echo "cart-item-canvas";
                    } ?>" href="<?php echo esc_url( wc_get_cart_url() ); ?>">
                    <span class="name-cart"><?php echo esc_html__('Cart','wibar'); ?></span>
                    <i class="fa fa-shopping-basket"></i>
                    <?php echo wp_kses_post(ftc_cart_total()); ?>
                </a>
            </div>
            <?php if( isset($smof_data['ftc_cart_layout']) && $smof_data['ftc_cart_layout'] == 'dropdown'): ?>
                <div class="tini-cart-inner">
                    <div class="woocommerce widget_shopping_cart">
                        <div class="widget_shopping_cart_content">
                            <?php echo wp_kses_post(woocommerce_mini_cart()); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }
}
/* *  Tiny Cart v2 * */
if (!function_exists('wibar_tiny_cart_v3')) {

    function wibar_tiny_cart_v3() {
        if (!wibar_has_woocommerce()) {
            return '';
        }
        global $smof_data;
        ob_start();
        ?>
        <div class="ftc-tini-cart cart_v3">
            <div class="cart-item">
                <a class="ftc-cart-tini <?php if($smof_data['ftc_cart_layout'] == 'off-canvas') {
                    echo "cart-item-canvas";
                } ?>" href="<?php echo esc_url( wc_get_cart_url() ); ?>">
                <div class="cart-le"><i class="fa fa-shopping-bag sad"></i></div>
                <div class="cart-ri">
                    <div class="shopping"><?php echo esc_html_e('my cart ','wibar'); ?></div>
                    <?php echo wp_kses_post(ftc_cart_total_v3()); ?>

                </a>
            </div>
            <?php if( isset($smof_data['ftc_cart_layout']) && $smof_data['ftc_cart_layout'] == 'dropdown'): ?>
                <div class="tini-cart-inner">
                    <div class="woocommerce widget_shopping_cart">
                        <div class="widget_shopping_cart_content">
                            <?php echo wp_kses_post(woocommerce_mini_cart()); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }
}
/* *  Tiny Cart v2 * */
if (!function_exists('wibar_tiny_cart_v2')) {

    function wibar_tiny_cart_v2() {
        if (!wibar_has_woocommerce()) {
            return '';
        }
        global $smof_data;
        ob_start();
        ?>
        <div class="ftc-tini-cart cart_v2">
            <div class="cart-item">
                <a class="ftc-cart-tini <?php if( isset($smof_data['ftc_cart_layout']) && $smof_data['ftc_cart_layout'] == 'off-canvas') {
                    echo "cart-item-canvas";
                } ?>" href="<?php echo esc_url( wc_get_cart_url() ); ?>">
                <div class="cart-le"><i class="fa fa-shopping-bag sad"></i></div>
                <div class="cart-ri">
                    <div class="shopping"><?php echo esc_html_e('SHOPPING CART','wibar'); ?></div>
                    <?php echo wp_kses_post(ftc_cart_total_v2()); ?>
                </a>
            </div>
            <?php if( isset($smof_data['ftc_cart_layout']) && $smof_data['ftc_cart_layout'] == 'dropdown'): ?>
                <div class="tini-cart-inner">
                    <div class="woocommerce widget_shopping_cart">
                        <div class="widget_shopping_cart_content">
                            <?php echo wp_kses_post(woocommerce_mini_cart()); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }
}
add_action('wp_footer', 'ftc_canvas_cart');
function ftc_canvas_cart(){
    if (!wibar_has_woocommerce()) {
        return '';
    }
    global $smof_data;
    ?>
    <?php if( isset($smof_data['ftc_cart_layout']) && $smof_data['ftc_cart_layout'] == 'off-canvas'): ?>
        <div class="ftc-off-canvas-cart">
            <div class="off-canvas-cart-title">
                <div class="title"><?php echo esc_html__('Shopping Cart', 'wibar'); ?></div>
                <span class="close-cart"> <?php echo esc_html__('Close', 'wibar') ?></span>
            </div>
            <div class="off-can-vas-inner">
                <div class="woocommerce widget_shopping_cart">
                    <div class="widget_shopping_cart_content">
                        <?php echo wp_kses_post(woocommerce_mini_cart()); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <?php

}

function ftc_cart_total() {
    ob_start();
    ?>
    <div class="cart-total"><?php echo WC()->cart->get_cart_contents_count() ?></div>
    <?php
    return ob_get_clean();
}
function ftc_cart_total_v2() {
    ob_start();
    ?>

    <div class="cart-totala">
        <?php echo WC()->cart->get_cart_contents_count() ?> Item(s) - 
        <span class="cart-sub"><?php echo WC()->cart->get_cart_subtotal(); ?></span>
    </div>
</div>
<?php
return ob_get_clean();
}

function ftc_cart_total_v3() {
    ob_start();
    ?>
    <div class="cart-totalav3">
        <?php echo WC()->cart->get_cart_contents_count() ?> <span class="items10">items</span> 

    </div>
</div>
<?php
return ob_get_clean();
}
add_filter('woocommerce_add_to_cart_fragments', 'ftc_tiny_cart_filter');

function ftc_tiny_cart_filter($fragments) {
    $fragments['.cart-total'] = ftc_cart_total();
    return $fragments;
}


function ftc_tiny_cart_filter_v2($fragments) {
    $fragments['.cart-totala'] = ftc_cart_total_v2();
    return $fragments;
}
function ftc_tiny_cart_filter_v3($fragments) {
    $fragments['.cart-totalav3'] = ftc_cart_total_v3();
    return $fragments;
}
add_filter('woocommerce_add_to_cart_fragments', 'ftc_tiny_cart_filter_v2');
add_filter('woocommerce_add_to_cart_fragments', 'ftc_tiny_cart_filter_v3');
/*Cart footer*/
add_filter('woocommerce_add_to_cart_fragments', 'ftc_cart_filter');
function ftc_cart_filter($fragments) {
    ob_start();
    ftc_cart_subtotal();
    $subtotal = ob_get_clean();
    $fragments['span.footer-cart-number'] = $subtotal;

    return $fragments;
}

if( ! function_exists( 'ftc_cart_subtotal' ) ) {
    function ftc_cart_subtotal() {
        ?>
        <span class="footer-cart-number"> <?php echo "(". WC()->cart->get_cart_contents_count().  ")"?></span>
        <?php
    }
}
/** Tini wishlist * */
function wibar_tini_wishlist() {
    if (!(wibar_has_woocommerce() && class_exists('YITH_WCWL'))) {
        return;
    }

    ob_start();

    $wishlist_page_id = get_option('yith_wcwl_wishlist_page_id');
    if (function_exists('wpml_object_id_filter')) {
        $wishlist_page_id = wpml_object_id_filter($wishlist_page_id, 'page', true);
    }
    $wishlist_page = get_permalink($wishlist_page_id);

    $count = yith_wcwl_count_products();
    ?>

    <a title="<?php echo esc_html_e('Wishlist', 'wibar'); ?>" href="<?php echo esc_url($wishlist_page); ?>" class="tini-wishlist">
        <i class="fa fa-heart"></i>  
        <?php echo esc_html__('Wishlist', 'wibar'); ?><span class="count-wish"><?php echo '(' . esc_html($count > 0 ? zeroise($count, 0) : '0') . ')'; ?></span>
    </a>

    <?php
    $tini_wishlist = ob_get_clean();
    return $tini_wishlist;
}

function wibar_update_tini_wishlist() {
    check_ajax_referer( 'platform_security', 'security' );
    wp_die(wibar_tini_wishlist());
}

add_action('wp_ajax_update_tini_wishlist', 'wibar_update_tini_wishlist');
add_action('wp_ajax_nopriv_update_tini_wishlist', 'wibar_update_tini_wishlist');

if( !function_exists('wibar_woocommerce_multilingual_currency_switcher') ){
    function wibar_woocommerce_multilingual_currency_switcher(){
        if( class_exists('woocommerce_wpml') && class_exists('WooCommerce') && class_exists('SitePress') ){
            global $sitepress, $woocommerce_wpml;

            if( !isset($woocommerce_wpml->multi_currency) ){
                return;
            }

            $settings = $woocommerce_wpml->get_settings();

            $format = isset($settings['wcml_curr_template']) && $settings['wcml_curr_template'] != '' ? $settings['wcml_curr_template']:'%code%';
            $wc_currencies = get_woocommerce_currencies();
            if( !isset($settings['currencies_order']) ){
                $currencies = $woocommerce_wpml->multi_currency->get_currency_codes();
            }else{
                $currencies = $settings['currencies_order'];
            }

            $selected_html = '';
            foreach( $currencies as $currency ){
                if($woocommerce_wpml->settings['currency_options'][$currency]['languages'][$sitepress->get_current_language()] == 1 ){
                    $currency_format = preg_replace(array('#%name%#', '#%symbol%#', '#%code%#'),
                        array($wc_currencies[$currency], get_woocommerce_currency_symbol($currency), $currency), $format);

                    if( $currency == $woocommerce_wpml->multi_currency->get_client_currency() ){
                        $selected_html = '<a href="javascript: void(0)" class="wcml_selected_currency">'.$currency_format.'</a>';
                        break;
                    }
                }
            }

            echo '<div class="wcml_currency_switcher">';
            print_r($selected_html);
            echo '<ul>';

            foreach( $currencies as $currency ){
                if($woocommerce_wpml->settings['currency_options'][$currency]['languages'][$sitepress->get_current_language()] == 1 ){
                    $currency_format = preg_replace(array('#%name%#', '#%symbol%#', '#%code%#'),
                        array($wc_currencies[$currency], get_woocommerce_currency_symbol($currency), $currency), $format);
                    echo '<li rel="' . $currency . '" >' . $currency_format . '</li>';
                }
            }

            echo '</ul>';
            echo '</div>';
        }
        else if( class_exists('WOOCS') && class_exists('WooCommerce') ){ /* Support WooCommerce Currency Switcher */
            global $WOOCS;
            $currencies = $WOOCS->get_currencies();
            if( !is_array($currencies) ){
                return;
            }
            ?>
            <div class="wcml_currency_switcher">
                <a href="javascript: void(0)" class="wcml_selected_currency"><?php echo esc_html($WOOCS->current_currency); ?></a>
                <ul>
                    <?php 
                    foreach( $currencies as $key => $currency ){
                        $link = add_query_arg('currency', $currency['name']);
                        echo '<li rel="'.$currency['name'].'"><a href="'.esc_url($link).'">'.esc_html($currency['name']).'</a></li>';
                    }
                    ?>
                </ul>
            </div>
            <?php
        }else{/* Demo html */
            ?>
            <div class="wcml_currency_switcher">
                <a href="javascript: void(0)" class="wcml_selected_currency"><?php echo esc_html__('USD','wibar'); ?></a>
                <ul>
                    <li rel="USD"><a href="#"><?php echo esc_html__('USD','wibar'); ?></a></li>
                    <li rel="EUR"><a href="#"><?php echo esc_html__('EUR','wibar'); ?></a></li>
                    <li rel="AUD"><a href="#"><?php echo esc_html__('AUD','wibar'); ?></a></li>
                </ul>
            </div>
            <?php
        }
    }
}

if( !function_exists('wibar_wpml_language_selector') ){
    function wibar_wpml_language_selector(){
        if( class_exists('SitePress') ){
            global $sitepress;
            if( method_exists($sitepress, 'get_mobile_language_selector') ){
               print_r($sitepress->get_mobile_language_selector());
           }
       }
       else{ /* Demo html */
        ?>
        <div id="lang_sel_click" class="lang_sel_click">
            <ul>
                <li>
                    <a href="#" class="lang_sel_sel icl-en"><?php echo esc_html__('English','wibar'); ?></a>
                    <ul style="visibility: hidden;">
                        <li class="icl-fr"><a rel="alternate" href="#"><span class="icl_lang_sel_native"><?php echo esc_html__('French','wibar'); ?></span></a></li>
                        <li class="icl-de"><a rel="alternate" href="#"><span class="icl_lang_sel_native"><?php echo esc_html__('German','wibar'); ?></span></a></li>
                    </ul>
                </li>
            </ul>
        </div>
        <?php
    }
}
}

function ftc_boxed_sidebar_filter(){
    global $smof_data;
    if($smof_data['ftc_prod_cat_layout'] == '0-1-0' && isset($smof_data['ftc_prod_box_sidebar_filter']) && $smof_data['ftc_prod_box_sidebar_filter']) {
        echo '<div class="ftc-filter-boxed">';
        if( is_active_sidebar($smof_data['ftc_prod_cat_left_sidebar']) ){
            dynamic_sidebar( $smof_data['ftc_prod_cat_left_sidebar'] ); 
        }
        echo '</div>';
    }
}


?>