<?php 
add_action( 'vc_before_init', 'wibar_integrate_with_vc' );
function wibar_integrate_with_vc() {
	
	if( !function_exists('vc_map') ){
		return;
	}

	/********************** Content Shortcodes ***************************/
	/*** FTC Our Team ***/
	$team_options = array();
	if( class_exists('FTC_Team_Members') || post_type_exists('ftc_team') ){
		$args = array(
			'post_type'				=> 'ftc_team'
			,'post_status'			=> 'publish'
			,'ignore_sticky_posts'	=> true
			,'posts_per_page'		=> -1
		);
		$teams = new WP_Query($args);
		if( $teams->have_posts() ){
			global $post;
			while( $teams->have_posts() ){
				$teams->the_post();
				$team_options[$post->post_title] = $post->ID;
			}
		}
		wp_reset_postdata();
	}
	
	vc_map( array(
		'name' 		=> esc_html__( 'FTC Our Team', 'wibar' ),
		'base' 		=> 'ftc_team_member',
		'class' 	=> '',
		'category' 	=> 'ThemeFTC',
		"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
		'params' 	=> array(
			array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Member name', 'wibar' )
				,'param_name' 	=> 'id'
				,'admin_label' 	=> true
				,'value' 		=> $team_options
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Number of words in excerpt', 'wibar' )
				,'param_name' 	=> 'excerpt_words'
				,'admin_label' 	=> true
				,'value' 		=> '30'
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Target', 'wibar' )
				,'param_name' 	=> 'target'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('New Window Tab', 'wibar')	=>  '_blank'
					,esc_html__('Self', 'wibar')			=>  '_self'	
				)
				,'description' 	=> ''
			)
		)
	) );
	/*** FTC Features ***/
	vc_map( array(
		'name' 		=> esc_html__( 'FTC Feature', 'wibar' ),
		'base' 		=> 'ftc_feature',
		'class' 	=> '',
		'category' 	=> 'ThemeFTC',
		"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
		'params' 	=> array(
			array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Style', 'wibar' )
				,'param_name' 	=> 'style'
				,'admin_label' 	=> true
				,'value' 		=> array(
					esc_html__('Horizontal', 'wibar')		=>  'feature-horizontal'
					,esc_html__('Vertical', 'wibar')		=>  'image-feature'
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Icon class', 'wibar' )
				,'param_name' 	=> 'class_icon'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> esc_html__('Use FontAwesome. Ex: fa-home', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Style icon', 'wibar' )
				,'param_name' 	=> 'style_icon'
				,'admin_label' 	=> true
				,'value' 		=> array(
					esc_html__('Default', 'wibar')		=>  'icon-default'
					,esc_html__('Small', 'wibar')			=>  'icon-small'
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'attach_image'
				,'heading' 		=> esc_html__( 'Image Thumbnail', 'wibar' )
				,'param_name' 	=> 'img_id'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> ''
				,'dependency'  	=> array('element' => 'style', 'value' => array('image-feature'))
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Image Thumbnail URL', 'wibar' )
				,'param_name' 	=> 'img_url'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> esc_html__('Input external URL instead of image from library', 'wibar')
				,'dependency' 	=> array('element' => 'style', 'value' => array('image-feature'))
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Feature title', 'wibar' )
				,'param_name' 	=> 'title'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'textarea'
				,'heading' 		=> esc_html__( 'Short description', 'wibar' )
				,'param_name' 	=> 'excerpt'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Link', 'wibar' )
				,'param_name' 	=> 'link'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Target', 'wibar' )
				,'param_name' 	=> 'target'
				,'admin_label' 	=> true
				,'value' 		=> array(
					esc_html__('New Window Tab', 'wibar')	=>  '_blank'
					,esc_html__('Self', 'wibar')			=>  '_self'
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Extra class', 'wibar' )
				,'param_name' 	=> 'extra_class'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> esc_html__('Ex: feature-icon-blue, feature-icon-orange, feature-icon-green', 'wibar')
			)
		)
	) );
	
	/*** FTC Blogs ***/
	vc_map( array(
		'name' 		=> esc_html__( 'FTC Blogs', 'wibar' ),
		'base' 		=> 'ftc_blogs',
		'base' 		=> 'ftc_blogs',
		'class' 	=> '',
		'category' 	=> 'ThemeFTC',
		"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
		'params' 	=> array(
			array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Block title', 'wibar' )
				,'param_name' 	=> 'title'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Style of Blog', 'wibar' )
				,'param_name' 	=> 'style'
				,'admin_label' 	=> true
				,'value' 		=> array(
					esc_html__('default', 'wibar')				=> ''
					,esc_html__('Blog Home 12', 'wibar')				=> 'blog-home12'
					,esc_html__('Blog full width', 'wibar')				=> 'blog-fullwidth'
					,esc_html__('Blog sidebar', 'wibar')				=> 'blog-sidebar'
					,esc_html__('Blog medium', 'wibar')				=> 'blog-medium'
					,esc_html__('Blog no sidebar', 'wibar')				=> 'blog-no-sidebar'
				)
				,'description' => esc_html__( 'Select Style of Blog', 'wibar' )
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Layout', 'wibar' )
				,'param_name' 	=> 'layout'
				,'admin_label' 	=> true
				,'value' 		=> array(
					esc_html__('Slider', 'wibar')	=> 'slider'
					,esc_html__('Grid', 'wibar')		=> 'grid'
					,esc_html__('Masonry', 'wibar')	=> 'masonry'
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Columns', 'wibar' )
				,'param_name' 	=> 'columns'
				,'admin_label' 	=> true
				,'value' 		=> array(
					'1'				=> '1'
					,'2'			=> '2'
					,'3'			=> '3'
					,'4'			=> '4'
				)
				,'description' 	=> esc_html__( 'Number of Columns', 'wibar' )
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Limit', 'wibar' )
				,'param_name' 	=> 'per_page'
				,'admin_label' 	=> true
				,'value' 		=> 5
				,'description' 	=> esc_html__( 'Number of Posts', 'wibar' )
			)
			,array(
				'type' 			=> 'ftc_category'
				,'heading' 		=> esc_html__( 'Categories', 'wibar' )
				,'param_name' 	=> 'categories'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> ''
				,'class'		=> 'post_cat'
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Order by', 'wibar' )
				,'param_name' 	=> 'orderby'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('None', 'wibar')		=> 'none'
					,esc_html__('ID', 'wibar')		=> 'ID'
					,esc_html__('Date', 'wibar')		=> 'date'
					,esc_html__('Name', 'wibar')		=> 'name'
					,esc_html__('Title', 'wibar')		=> 'title'
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Order', 'wibar' )
				,'param_name' 	=> 'order'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Descending', 'wibar')		=> 'DESC'
					,esc_html__('Ascending', 'wibar')		=> 'ASC'
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show post title', 'wibar' )
				,'param_name' 	=> 'show_title'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show thumbnail', 'wibar' )
				,'param_name' 	=> 'show_thumbnail'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show author', 'wibar' )
				,'param_name' 	=> 'show_author'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('No', 'wibar')	=> 0
					,esc_html__('Yes', 'wibar')	=> 1
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show comment', 'wibar' )
				,'param_name' 	=> 'show_comment'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show date', 'wibar' )
				,'param_name' 	=> 'show_date'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show post excerpt', 'wibar' )
				,'param_name' 	=> 'show_excerpt'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show count view', 'wibar' )
				,'param_name' 	=> 'show_view'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show read more button', 'wibar' )
				,'param_name' 	=> 'show_readmore'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Number of words in excerpt', 'wibar' )
				,'param_name' 	=> 'excerpt_words'
				,'admin_label' 	=> false
				,'value' 		=> '16'
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show load more button', 'wibar' )
				,'param_name' 	=> 'show_load_more'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('No', 'wibar')	=> 0
					,esc_html__('Yes', 'wibar')	=> 1
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Load more button text', 'wibar' )
				,'param_name' 	=> 'load_more_text'
				,'admin_label' 	=> false
				,'value' 		=> 'Show more'
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show navigation button', 'wibar' )
				,'param_name' 	=> 'show_nav'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
				,'group'		=> esc_html__('Slider Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show dots button', 'wibar' )
				,'param_name' 	=> 'dots'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
				,'group'		=> esc_html__('Slider Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Auto play', 'wibar' )
				,'param_name' 	=> 'auto_play'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
				,'group'		=> esc_html__('Slider Options', 'wibar')
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Margin', 'wibar' )
				,'param_name' 	=> 'margin'
				,'admin_label' 	=> false
				,'value' 		=> '30'
				,'description' 	=> esc_html__('Set margin between items', 'wibar')
				,'group'		=> esc_html__('Slider Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Desktop small items', 'wibar' )
				,'param_name' 	=> 'desksmall_items'
				,'admin_label' 	=> false
				,'value' 		=>  array(
					esc_html__('1', 'wibar')	=> 1
					,esc_html__('2', 'wibar')	=> 2
					,esc_html__('3', 'wibar')	=> 3
					,esc_html__('4', 'wibar')	=> 4
					
				)
				,'description' 	=> esc_html__('Set items on 991px', 'wibar')
				,'group'		=> esc_html__('Responsive Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Tablet items', 'wibar' )
				,'param_name' 	=> 'tablet_items'
				,'admin_label' 	=> false
				,'value' 		=>  array(
					esc_html__('1', 'wibar')	=> 1
					,esc_html__('2', 'wibar')	=> 2
					,esc_html__('3', 'wibar')	=> 3
					
				)
				,'description' 	=> esc_html__('Set items on 768px', 'wibar')
				,'group'		=> esc_html__('Responsive Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Tablet mini items', 'wibar' )
				,'param_name' 	=> 'tabletmini_items'
				,'admin_label' 	=> false
				,'value' 		=>  array(
					esc_html__('1', 'wibar')	=> 1
					,esc_html__('2', 'wibar')	=> 2
					,esc_html__('3', 'wibar')	=> 3
					
				)
				,'description' 	=> esc_html__('Set items on 640px', 'wibar')
				,'group'		=> esc_html__('Responsive Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Mobile items', 'wibar' )
				,'param_name' 	=> 'mobile_items'
				,'admin_label' 	=> false
				,'value' 		=>  array(
					esc_html__('1', 'wibar')	=> 1
					,esc_html__('2', 'wibar')	=> 2
					
				)
				,'description' 	=> esc_html__('Set items on 480px', 'wibar')
				,'group'		=> esc_html__('Responsive Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Mobile small items', 'wibar' )
				,'param_name' 	=> 'mobilesmall_items'
				,'admin_label' 	=> false
				,'value' 		=>  array(
					esc_html__('1', 'wibar')	=> 1
					,esc_html__('2', 'wibar')	=> 2
					
				)
				,'description' 	=> esc_html__('Set items on 0px', 'wibar')
				,'group'		=> esc_html__('Responsive Options', 'wibar')
			)
		)
) );

/*** FTC Blogs ***/
	vc_map( array(
		'name' 		=> esc_html__( 'FTC Blog Timeline', 'wibar' ),
		'base' 		=> 'ftc_blog_timeline',
		'base' 		=> 'ftc_blog_timeline',
		'class' 	=> '',
		'category' 	=> 'ThemeFTC',
		"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
		'params' 	=> array(
			array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Block title', 'wibar' )
				,'param_name' 	=> 'title'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> ''
			)
			// ,array(
			// 	'type' 			=> 'dropdown'
			// 	,'heading' 		=> esc_html__( 'Style of Blog Timeline', 'wibar' )
			// 	,'param_name' 	=> 'style'
			// 	,'admin_label' 	=> true
			// 	,'value' 		=> array(
			// 		esc_html__('default', 'wibar')				=> ''
			// 		,esc_html__('2 Columns', 'wibar')				=> 'columns-2'
			// 	)
			// 	,'description' => esc_html__( 'Select Style of Blog', 'wibar' )
			// )
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Layout', 'wibar' )
				,'param_name' 	=> 'layout'
				,'admin_label' 	=> true
				,'value' 		=> array(
					esc_html__('Grid', 'wibar')		=> 'grid'
					,esc_html__('Masonry', 'wibar')	=> 'masonry'
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Columns', 'wibar' )
				,'param_name' 	=> 'columns'
				,'admin_label' 	=> true
				,'value' 		=> array(
					'1'				=> '1'
					,'2'			=> '2'
				)
				,'description' 	=> esc_html__( 'Number of Columns', 'wibar' )
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Limit', 'wibar' )
				,'param_name' 	=> 'per_page'
				,'admin_label' 	=> true
				,'value' 		=> 5
				,'description' 	=> esc_html__( 'Number of Posts', 'wibar' )
			)
			,array(
				'type' 			=> 'ftc_category'
				,'heading' 		=> esc_html__( 'Categories', 'wibar' )
				,'param_name' 	=> 'categories'
				,'admin_label' 	=> true
				,'value' 		=> ''
				,'description' 	=> ''
				,'class'		=> 'post_cat'
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Order by', 'wibar' )
				,'param_name' 	=> 'orderby'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('None', 'wibar')		=> 'none'
					,esc_html__('ID', 'wibar')		=> 'ID'
					,esc_html__('Date', 'wibar')		=> 'date'
					,esc_html__('Name', 'wibar')		=> 'name'
					,esc_html__('Title', 'wibar')		=> 'title'
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Order', 'wibar' )
				,'param_name' 	=> 'order'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Descending', 'wibar')		=> 'DESC'
					,esc_html__('Ascending', 'wibar')		=> 'ASC'
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show post title', 'wibar' )
				,'param_name' 	=> 'show_title'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show thumbnail', 'wibar' )
				,'param_name' 	=> 'show_thumbnail'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show author', 'wibar' )
				,'param_name' 	=> 'show_author'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('No', 'wibar')	=> 0
					,esc_html__('Yes', 'wibar')	=> 1
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show comment', 'wibar' )
				,'param_name' 	=> 'show_comment'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show date', 'wibar' )
				,'param_name' 	=> 'show_date'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show post excerpt', 'wibar' )
				,'param_name' 	=> 'show_excerpt'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show count view', 'wibar' )
				,'param_name' 	=> 'show_view'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show read more button', 'wibar' )
				,'param_name' 	=> 'show_readmore'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Number of words in excerpt', 'wibar' )
				,'param_name' 	=> 'excerpt_words'
				,'admin_label' 	=> false
				,'value' 		=> '16'
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show load more button', 'wibar' )
				,'param_name' 	=> 'show_load_more'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('No', 'wibar')	=> 0
					,esc_html__('Yes', 'wibar')	=> 1
				)
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Load more button text', 'wibar' )
				,'param_name' 	=> 'load_more_text'
				,'admin_label' 	=> false
				,'value' 		=> 'Show more'
				,'description' 	=> ''
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show navigation button', 'wibar' )
				,'param_name' 	=> 'show_nav'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
				,'group'		=> esc_html__('Slider Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Show dots button', 'wibar' )
				,'param_name' 	=> 'dots'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
				,'group'		=> esc_html__('Slider Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Auto play', 'wibar' )
				,'param_name' 	=> 'auto_play'
				,'admin_label' 	=> false
				,'value' 		=> array(
					esc_html__('Yes', 'wibar')	=> 1
					,esc_html__('No', 'wibar')	=> 0
				)
				,'description' 	=> ''
				,'group'		=> esc_html__('Slider Options', 'wibar')
			)
			,array(
				'type' 			=> 'textfield'
				,'heading' 		=> esc_html__( 'Margin', 'wibar' )
				,'param_name' 	=> 'margin'
				,'admin_label' 	=> false
				,'value' 		=> '30'
				,'description' 	=> esc_html__('Set margin between items', 'wibar')
				,'group'		=> esc_html__('Slider Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Desktop small items', 'wibar' )
				,'param_name' 	=> 'desksmall_items'
				,'admin_label' 	=> false
				,'value' 		=>  array(
					esc_html__('1', 'wibar')	=> 1
					,esc_html__('2', 'wibar')	=> 2
					,esc_html__('3', 'wibar')	=> 3
					,esc_html__('4', 'wibar')	=> 4
					
				)
				,'description' 	=> esc_html__('Set items on 991px', 'wibar')
				,'group'		=> esc_html__('Responsive Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Tablet items', 'wibar' )
				,'param_name' 	=> 'tablet_items'
				,'admin_label' 	=> false
				,'value' 		=>  array(
					esc_html__('1', 'wibar')	=> 1
					,esc_html__('2', 'wibar')	=> 2
					,esc_html__('3', 'wibar')	=> 3
					,esc_html__('4', 'wibar')	=> 4
					
				)
				,'description' 	=> esc_html__('Set items on 768px', 'wibar')
				,'group'		=> esc_html__('Responsive Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Tablet mini items', 'wibar' )
				,'param_name' 	=> 'tabletmini_items'
				,'admin_label' 	=> false
				,'value' 		=>  array(
					esc_html__('1', 'wibar')	=> 1
					,esc_html__('2', 'wibar')	=> 2
					,esc_html__('3', 'wibar')	=> 3
					,esc_html__('4', 'wibar')	=> 4
					
				)
				,'description' 	=> esc_html__('Set items on 640px', 'wibar')
				,'group'		=> esc_html__('Responsive Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Mobile items', 'wibar' )
				,'param_name' 	=> 'mobile_items'
				,'admin_label' 	=> false
				,'value' 		=>  array(
					esc_html__('1', 'wibar')	=> 1
					,esc_html__('2', 'wibar')	=> 2
					,esc_html__('3', 'wibar')	=> 3
					,esc_html__('4', 'wibar')	=> 4
					
				)
				,'description' 	=> esc_html__('Set items on 480px', 'wibar')
				,'group'		=> esc_html__('Responsive Options', 'wibar')
			)
			,array(
				'type' 			=> 'dropdown'
				,'heading' 		=> esc_html__( 'Mobile small items', 'wibar' )
				,'param_name' 	=> 'mobilesmall_items'
				,'admin_label' 	=> false
				,'value' 		=>  array(
					esc_html__('1', 'wibar')	=> 1
					,esc_html__('2', 'wibar')	=> 2
					,esc_html__('3', 'wibar')	=> 3
					,esc_html__('4', 'wibar')	=> 4
					
				)
				,'description' 	=> esc_html__('Set items on 0px', 'wibar')
				,'group'		=> esc_html__('Responsive Options', 'wibar')
			)
		)
) );
/*** FTC Blogs V2***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Blogs V2', 'wibar' ),
	'base' 		=> 'ftc_bloger',
	'base' 		=> 'ftc_bloger',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Block title', 'wibar' )
			,'param_name' 	=> 'title'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Layout', 'wibar' )
			,'param_name' 	=> 'layout'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Grid', 'wibar')		=> 'grid'
				,esc_html__('Slider', 'wibar')	=> 'slider'
				,esc_html__('Masonry', 'wibar')	=> 'masonry'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Columns', 'wibar' )
			,'param_name' 	=> 'columns'
			,'admin_label' 	=> true
			,'value' 		=> array(
				'1'				=> '1'
				,'2'			=> '2'
				,'3'			=> '3'
				,'4'			=> '4'
			)
			,'description' 	=> esc_html__( 'Number of Columns', 'wibar' )
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Limit', 'wibar' )
			,'param_name' 	=> 'per_page'
			,'admin_label' 	=> true
			,'value' 		=> 5
			,'description' 	=> esc_html__( 'Number of Posts', 'wibar' )
		)
		,array(
			'type' 			=> 'ftc_category'
			,'heading' 		=> esc_html__( 'Categories', 'wibar' )
			,'param_name' 	=> 'categories'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
			,'class'		=> 'post_cat'
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Order by', 'wibar' )
			,'param_name' 	=> 'orderby'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('None', 'wibar')		=> 'none'
				,esc_html__('ID', 'wibar')		=> 'ID'
				,esc_html__('Date', 'wibar')		=> 'date'
				,esc_html__('Name', 'wibar')		=> 'name'
				,esc_html__('Title', 'wibar')		=> 'title'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Order', 'wibar' )
			,'param_name' 	=> 'order'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Descending', 'wibar')		=> 'DESC'
				,esc_html__('Ascending', 'wibar')		=> 'ASC'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show post title', 'wibar' )
			,'param_name' 	=> 'show_title'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show thumbnail', 'wibar' )
			,'param_name' 	=> 'show_thumbnail'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show author', 'wibar' )
			,'param_name' 	=> 'show_author'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')	=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show comment', 'wibar' )
			,'param_name' 	=> 'show_comment'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show date', 'wibar' )
			,'param_name' 	=> 'show_date'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show post excerpt', 'wibar' )
			,'param_name' 	=> 'show_excerpt'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show count view', 'wibar' )
			,'param_name' 	=> 'show_view'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show read more button', 'wibar' )
			,'param_name' 	=> 'show_readmore'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Number of words in excerpt', 'wibar' )
			,'param_name' 	=> 'excerpt_words'
			,'admin_label' 	=> false
			,'value' 		=> '16'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show load more button', 'wibar' )
			,'param_name' 	=> 'show_load_more'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')	=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Load more button text', 'wibar' )
			,'param_name' 	=> 'load_more_text'
			,'admin_label' 	=> false
			,'value' 		=> 'Show more'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show navigation button', 'wibar' )
			,'param_name' 	=> 'show_nav'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show dots button', 'wibar' )
			,'param_name' 	=> 'dots'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Auto play', 'wibar' )
			,'param_name' 	=> 'auto_play'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Margin', 'wibar' )
			,'param_name' 	=> 'margin'
			,'admin_label' 	=> false
			,'value' 		=> '30'
			,'description' 	=> esc_html__('Set margin between items', 'wibar')
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Desktop small items', 'wibar' )
			,'param_name' 	=> 'desksmall_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 991px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Tablet items', 'wibar' )
			,'param_name' 	=> 'tablet_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 768px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Tablet mini items', 'wibar' )
			,'param_name' 	=> 'tabletmini_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 640px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Mobile items', 'wibar' )
			,'param_name' 	=> 'mobile_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 480px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Mobile small items', 'wibar' )
			,'param_name' 	=> 'mobilesmall_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 0px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
	)
) );
/*** FTC Button ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Button', 'wibar' ),
	'base' 		=> 'ftc_button',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Text', 'wibar' )
			,'param_name' 	=> 'content'
			,'admin_label' 	=> true
			,'value' 		=> 'Button text'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link', 'wibar' )
			,'param_name' 	=> 'link'
			,'admin_label' 	=> true
			,'value' 		=> '#'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'colorpicker'
			,'heading' 		=> esc_html__( 'Text color', 'wibar' )
			,'param_name' 	=> 'text_color'
			,'admin_label' 	=> false
			,'value' 		=> '#ffffff'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'colorpicker'
			,'heading' 		=> esc_html__( 'Text color hover', 'wibar' )
			,'param_name' 	=> 'text_color_hover'
			,'admin_label' 	=> false
			,'value' 		=> '#ffffff'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'colorpicker'
			,'heading' 		=> esc_html__( 'Background color', 'wibar' )
			,'param_name' 	=> 'bg_color'
			,'admin_label' 	=> false
			,'value' 		=> '#40bea7'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'colorpicker'
			,'heading' 		=> esc_html__( 'Background color hover', 'wibar' )
			,'param_name' 	=> 'bg_color_hover'
			,'admin_label' 	=> false
			,'value' 		=> '#3f3f3f'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'colorpicker'
			,'heading' 		=> esc_html__( 'Border color', 'wibar' )
			,'param_name' 	=> 'border_color'
			,'admin_label' 	=> false
			,'value' 		=> '#e8e8e8'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'colorpicker'
			,'heading' 		=> esc_html__( 'Border color hover', 'wibar' )
			,'param_name' 	=> 'border_color_hover'
			,'admin_label' 	=> false
			,'value' 		=> '#40bea7'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Border width', 'wibar' )
			,'param_name' 	=> 'border_width'
			,'admin_label' 	=> false
			,'value' 		=> '0'
			,'description' 	=> esc_html__('In pixels. Ex: 1', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Target', 'wibar' )
			,'param_name' 	=> 'target'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Self', 'wibar')				=> '_self'
				,esc_html__('New Window Tab', 'wibar')	=> '_blank'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Size', 'wibar' )
			,'param_name' 	=> 'size'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Small', 'wibar')		=> 'small'
				,esc_html__('Medium', 'wibar')	=> 'medium'
				,esc_html__('Large', 'wibar')		=> 'large'
				,esc_html__('X-Large', 'wibar')	=> 'x-large'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'iconpicker'
			,'heading' 		=> esc_html__( 'Font icon', 'wibar' )
			,'param_name' 	=> 'font_icon'
			,'admin_label' 	=> false
			,'value' 		=> ''
			,'settings' 	=> array(
				'emptyIcon' 	=> true /* default true, display an "EMPTY" icon? */
				,'iconsPerPage' => 4000 /* default 100, how many icons per/page to display */
			)
			,'description' 	=> esc_html__('Add an icon before the text. Ex: fa-lock', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show popup', 'wibar' )
			,'param_name' 	=> 'popup'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('No', 'wibar')	=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
			,'group'		=> esc_html__('Popup Options', 'wibar')
		)
		,array(
			'type' 			=> 'textarea_raw_html'
			,'heading' 		=> esc_html__( 'Popup content', 'wibar' )
			,'param_name' 	=> 'popup_content'
			,'admin_label' 	=> false
			,'value' 		=> ''
			,'description' 	=> ''
			,'group'		=> esc_html__('Popup Options', 'wibar')
		)
	)
) );

/*** FTC Image Slider ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Image Slider', 'wibar' ),
	'base' 		=> 'ftc_image_slider',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'attach_image'
			,'heading' 		=> esc_html__( 'Image Slider 1', 'wibar' )
			,'param_name' 	=> 'img_1'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> 'Set image slider 1'
		)
		,array(
			'type' 			=> 'attach_image'
			,'heading' 		=> esc_html__( 'Image Slider 2', 'wibar' )
			,'param_name' 	=> 'img_2'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> 'Set image slider 2'
		)
		,array(
			'type' 			=> 'attach_image'
			,'heading' 		=> esc_html__( 'Image Slider 3', 'wibar' )
			,'param_name' 	=> 'img_3'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> 'Set image slider 3'
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link Image 1', 'wibar' )
			,'param_name' 	=> 'link_1'
			,'admin_label' 	=> true
			,'value' 		=> '#'
			,'description' 	=> ''
		)			
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link Title Image 1', 'wibar' )
			,'param_name' 	=> 'link_title_1'
			,'admin_label' 	=> false
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link_image_2', 'wibar' )
			,'param_name' 	=> 'link_2'
			,'admin_label' 	=> true
			,'value' 		=> '#'
			,'description' 	=> ''
		)						
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link Title Image 2', 'wibar' )
			,'param_name' 	=> 'link_title_2'
			,'admin_label' 	=> false
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link_image_3', 'wibar' )
			,'param_name' 	=> 'link_3'
			,'admin_label' 	=> true
			,'value' 		=> '#'
			,'description' 	=> ''
		)						
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link Title Image 3', 'wibar' )
			,'param_name' 	=> 'link_title_3'
			,'admin_label' 	=> false
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Target', 'wibar' )
			,'param_name' 	=> 'target'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('New Window Tab', 'wibar')		=> '_blank'
				,esc_html__('Self', 'wibar')				=> '_self'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Image Size', 'wibar' )
			,'param_name' 	=> 'img_size'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> esc_html__( 'Ex: thumbnail, medium, large or full', 'wibar' )
		)
		
	)
) );

/*** FTC Single Image ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Single Image', 'wibar' ),
	'base' 		=> 'ftc_single_image',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'attach_image'
			,'heading' 		=> esc_html__( 'Image', 'wibar' )
			,'param_name' 	=> 'img_id'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Image Size', 'wibar' )
			,'param_name' 	=> 'img_size'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> esc_html__( 'Ex: thumbnail, medium, large or full', 'wibar' )
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Image URL', 'wibar' )
			,'param_name' 	=> 'img_url'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> esc_html__('Input external URL instead of image from library', 'wibar')
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link', 'wibar' )
			,'param_name' 	=> 'link'
			,'admin_label' 	=> true
			,'value' 		=> '#'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link Title', 'wibar' )
			,'param_name' 	=> 'link_title'
			,'admin_label' 	=> false
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Hover Effect', 'wibar' )
			,'param_name' 	=> 'style_smooth'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Effect-Image Left Right', 'wibar')		=> 'smooth-image'
				,esc_html__('Effect Border Image', 'wibar')				=> 'smooth-border-image'
				,esc_html__('Effect Background Image', 'wibar')		=> 'smooth-background-image'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Target', 'wibar' )
			,'param_name' 	=> 'target'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('New Window Tab', 'wibar')		=> '_blank'
				,esc_html__('Self', 'wibar')				=> '_self'
			)
			,'description' 	=> ''
		)
	)
) );

/*** FTC Heading ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Heading', 'wibar' ),
	'base' 		=> 'ftc_heading',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Heading style', 'wibar' )
			,'param_name' 	=> 'style'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Style 1', 'wibar')		=> 'style-1'
				,esc_html__('Style 2', 'wibar')		=> 'style-2'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Heading Size', 'wibar' )
			,'param_name' 	=> 'size'
			,'admin_label' 	=> true
			,'value' 		=> array(
				'1'				=> '1'
				,'2'			=> '2'
				,'3'			=> '3'
				,'4'			=> '4'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Text', 'wibar' )
			,'param_name' 	=> 'text'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
	)
) );

/*** FTC Banner ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Banner', 'wibar' ),
	'base' 		=> 'ftc_banner',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'attach_image'
			,'heading' 		=> esc_html__( 'Background Image', 'wibar' )
			,'param_name' 	=> 'bg_id'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Background Url', 'wibar' )
			,'param_name' 	=> 'bg_url'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> esc_html__('Input external URL instead of image from library', 'wibar')
		)
		,array(
			'type' 			=> 'colorpicker'
			,'heading' 		=> esc_html__( 'Background Color', 'wibar' )
			,'param_name' 	=> 'bg_color'
			,'admin_label' 	=> false
			,'value' 		=> '#ffffff'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textarea_html'
			,'heading' 		=> esc_html__( 'Banner content', 'wibar' )
			,'param_name' 	=> 'content'
			,'admin_label' 	=> false
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Position Banner Content', 'wibar' )
			,'param_name' 	=> 'position_content'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Left Top', 'wibar')			=>  'left-top'
				,esc_html__('Left Bottom', 'wibar')		=>  'left-bottom'
				,esc_html__('Left Center', 'wibar')		=>  'left-center'
				,esc_html__('Right Top', 'wibar')			=>  'right-top'
				,esc_html__('Right Bottom', 'wibar')		=>  'right-bottom'
				,esc_html__('Right Center', 'wibar')		=>  'right-center'
				,esc_html__('Center Top', 'wibar')		=>  'center-top'
				,esc_html__('Center Bottom', 'wibar')		=>  'center-bottom'
				,esc_html__('Center Center', 'wibar')		=>  'center-center'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link', 'wibar' )
			,'param_name' 	=> 'link'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Link Title', 'wibar' )
			,'param_name' 	=> 'link_title'
			,'admin_label' 	=> false
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Style Effect', 'wibar' )
			,'param_name' 	=> 'style_smooth'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Background Scale', 'wibar')						=>  'ftc-smooth'
				,esc_html__('Background Scale Opacity', 'wibar')				=>  'ftc-smooth-opacity'
				,esc_html__('Background Scale Dark', 'wibar')					=>	'ftc-smooth-dark'
				,esc_html__('Background Scale and Line', 'wibar')				=>  'ftc-smooth-and-line'
				,esc_html__('Background Scale Opacity and Line', 'wibar')		=>  'ftc-smooth-opacity-line'
				,esc_html__('Background Scale Dark and Line', 'wibar')		=>  'ftc-smooth-dark-line'
				,esc_html__('Background Opacity and Line', 'wibar')			=>	'background-opacity-and-line'
				,esc_html__('Background Dark and Line', 'wibar')				=>	'background-dark-and-line'
				,esc_html__('Background Opacity', 'wibar')					=>	'background-opacity'
				,esc_html__('Background Dark', 'wibar')						=>	'background-dark'
				,esc_html__('Line', 'wibar')									=>	'eff-line'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Background Opacity On Device', 'wibar' )
			,'param_name' 	=> 'opacity_bg_device'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')			=>  0
				,esc_html__('Yes', 'wibar')		=>  1
			)
			,'description' 	=> esc_html__('Background image will be blurred on device. Note: should set background color ', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Responsive size', 'wibar' )
			,'param_name' 	=> 'responsive_size'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')		=>  1
				,esc_html__('No', 'wibar')		=>  0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Target', 'wibar' )
			,'param_name' 	=> 'target'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('New Window Tab', 'wibar')	=>  '_blank'
				,esc_html__('Self', 'wibar')			=>  '_self'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Extra Class', 'wibar' )
			,'param_name' 	=> 'extra_class'
			,'admin_label' 	=> false
			,'value' 		=> ''
			,'description' 	=> esc_html__('Ex: rp-rectangle-full, rp-rectangle', 'wibar')
		)
	)
) );

/* FTC Testimonial */
vc_map( array(
	'name' 		=> esc_html__( 'FTC Testimonial', 'wibar' ),
	'base' 		=> 'ftc_testimonial',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'ftc_category'
			,'heading' 		=> esc_html__( 'Categories', 'wibar' )
			,'param_name' 	=> 'categories'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
			,'class'		=> 'ftc_testimonial'
		)
		,array(
			'type' 			=> 'textarea'
			,'heading' 		=> esc_html__( 'Testimonial IDs', 'wibar' )
			,'param_name' 	=> 'ids'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> esc_html__('A comma separated list of testimonial ids', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show Avatar', 'wibar' )
			,'param_name' 	=> 'show_avatar'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Limit', 'wibar' )
			,'param_name' 	=> 'per_page'
			,'admin_label' 	=> true
			,'value' 		=> '4'
			,'description' 	=> esc_html__('Number of Posts', 'wibar')
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Number of words in excerpt', 'wibar' )
			,'param_name' 	=> 'excerpt_words'
			,'admin_label' 	=> true
			,'value' 		=> '50'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Text Color Style', 'wibar' )
			,'param_name' 	=> 'text_color_style'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Default', 'wibar')	=> 'text-default'
				,esc_html__('Light', 'wibar')		=> 'text-light'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show in a carousel slider', 'wibar' )
			,'param_name' 	=> 'is_slider'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Columns', 'wibar' )
			,'param_name' 	=> 'columns'
			,'admin_label' 	=> true
			,'value' 		=> '1'
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Margin', 'wibar' )
			,'param_name' 	=> 'margin'
			,'admin_label' 	=> true
			,'value' 		=> '30'
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show navigation button', 'wibar' )
			,'param_name' 	=> 'show_nav'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show pagination dots', 'wibar' )
			,'param_name' 	=> 'show_dots'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')	=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> esc_html__('If it is set, the navigation buttons will be removed', 'wibar')
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Auto play', 'wibar' )
			,'param_name' 	=> 'auto_play'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
	)
) );

/*** FTC Brands Slider ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Brands Slider', 'wibar' ),
	'base' 		=> 'ftc_brands_slider',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Block title', 'wibar' )
			,'param_name' 	=> 'title'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Style Brand', 'wibar' )
			,'param_name' 	=> 'style_brand'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Default', 'wibar')	=> 'style-default'
				,esc_html__('Light', 'wibar')		=> 'style-light'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Limit', 'wibar' )
			,'param_name' 	=> 'per_page'
			,'admin_label' 	=> true
			,'value' 		=> '7'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Rows', 'wibar' )
			,'param_name' 	=> 'rows'
			,'admin_label' 	=> true
			,'value' 		=> 1
			,'description' 	=> esc_html__( 'Number of Rows', 'wibar' )
		)
		,array(
			'type' 			=> 'ftc_category'
			,'heading' 		=> esc_html__( 'Categories', 'wibar' )
			,'param_name' 	=> 'categories'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
			,'class'		=> 'ftc_brand'
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Margin', 'wibar' )
			,'param_name' 	=> 'margin_image'
			,'admin_label' 	=> false
			,'value' 		=> '32'
			,'description' 	=> esc_html__('Set margin between items', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Activate link', 'wibar' )
			,'param_name' 	=> 'active_link'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show navigation button', 'wibar' )
			,'param_name' 	=> 'show_nav'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Auto play', 'wibar' )
			,'param_name' 	=> 'auto_play'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)

		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Desktop small items', 'wibar' )
			,'param_name' 	=> 'desksmall_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				,esc_html__('5', 'wibar')	=> 5
				,esc_html__('6', 'wibar')	=> 6
				
			)
			,'description' 	=> esc_html__('Set items on 991px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Tablet items', 'wibar' )
			,'param_name' 	=> 'tablet_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 768px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Tablet mini items', 'wibar' )
			,'param_name' 	=> 'tabletmini_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 640px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Mobile items', 'wibar' )
			,'param_name' 	=> 'mobile_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 480px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Mobile small items', 'wibar' )
			,'param_name' 	=> 'mobilesmall_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 0px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
	)
) );


/*** FTC Google Map ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Google Map', 'wibar' ),
	'base' 		=> 'ftc_google_map',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Address', 'wibar' )
			,'param_name' 	=> 'address'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> esc_html__('You have to input your API Key in Appearance > Theme Options > General tab', 'wibar')
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Height', 'wibar' )
			,'param_name' 	=> 'height'
			,'admin_label' 	=> true
			,'value' 		=> 360
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Zoom', 'wibar' )
			,'param_name' 	=> 'zoom'
			,'admin_label' 	=> true
			,'value' 		=> 12
			,'description' 	=> esc_html__('Input a number between 0 and 22', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Map Type', 'wibar' )
			,'param_name' 	=> 'map_type'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('ROADMAP', 'wibar')		=> 'ROADMAP'
				,esc_html__('SATELLITE', 'wibar')		=> 'SATELLITE'
				,esc_html__('HYBRID', 'wibar')		=> 'HYBRID'
				,esc_html__('TERRAIN', 'wibar')		=> 'TERRAIN'
			)
			,'description' 	=> ''
		)
	)
) );

/*** FTC Countdown ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Countdown', 'wibar' ),
	'base' 		=> 'wibar_countdown',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Day', 'wibar' )
			,'param_name' 	=> 'day'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Month', 'wibar' )
			,'param_name' 	=> 'month'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Year', 'wibar' )
			,'param_name' 	=> 'year'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Text Color Style', 'wibar' )
			,'param_name' 	=> 'text_color_style'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Default', 'wibar')	=> 'text-default'
				,esc_html__('Light', 'wibar')		=> 'text-light'
			)
			,'description' 	=> ''
		)
	)
) );

/*** FTC Feedburner Subscription ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Feedburner Subscription', 'wibar' ),
	'base' 		=> 'ftc_feedburner_subscription',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Feedburner ID', 'wibar' )
			,'param_name' 	=> 'feedburner_id'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Title', 'wibar' )
			,'param_name' 	=> 'title'
			,'admin_label' 	=> true
			,'value' 		=> 'Newsletter'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Intro Text Line 1', 'wibar' )
			,'param_name' 	=> 'intro_text'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Button Text', 'wibar' )
			,'param_name' 	=> 'button_text'
			,'admin_label' 	=> true
			,'value' 		=> 'Subscribe'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Placeholder Text', 'wibar' )
			,'param_name' 	=> 'placeholder_text'
			,'admin_label' 	=> true
			,'value' 		=> 'Enter your email address'
			,'description' 	=> ''
		)
	)
) );

/********************** FTC Product Shortcodes ************************/

/*** FTC Products ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Products', 'wibar' ),
	'base' 		=> 'ftc_products',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Block title', 'wibar' )
			,'param_name' 	=> 'title'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' => 'dropdown'
			,'heading' => esc_html__( 'Style of products', 'wibar' )
			,'param_name' => 'style'
			,'admin_label' => true
			,'value' => array(
				esc_html__('default', 'wibar')	=> ''
				,esc_html__('style_home10', 'wibar')	=> 'pro-home10'
				,esc_html__('style_home11', 'wibar')	=> 'pro-home11'
				,esc_html__('style_home12', 'wibar')	=> 'pro-home12'
			)
			,'description' => esc_html__( 'Select Style of product', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Product type', 'wibar' )
			,'param_name' 	=> 'product_type'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Recent', 'wibar')		=> 'recent'
				,esc_html__('Sale', 'wibar')		=> 'sale'
				,esc_html__('Featured', 'wibar')	=> 'featured'
				,esc_html__('Best Selling', 'wibar')	=> 'best_selling'
				,esc_html__('Top Rated', 'wibar')	=> 'top_rated'
				,esc_html__('Mixed Order', 'wibar')	=> 'mixed_order'
			)
			,'description' 	=> esc_html__( 'Select type of product', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Custom order', 'wibar' )
			,'param_name' 	=> 'custom_order'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('No', 'wibar')			=> 0
				,esc_html__('Yes', 'wibar')		=> 1
			)
			,'description' 	=> esc_html__( 'If you enable this option, the Product type option wont be available', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Order by', 'wibar' )
			,'param_name' 	=> 'orderby'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('None', 'wibar')				=> 'none'
				,esc_html__('ID', 'wibar')				=> 'ID'
				,esc_html__('Date', 'wibar')				=> 'date'
				,esc_html__('Name', 'wibar')				=> 'name'
				,esc_html__('Title', 'wibar')				=> 'title'
				,esc_html__('Comment count', 'wibar')		=> 'comment_count'
				,esc_html__('Random', 'wibar')			=> 'rand'
			)
			,'dependency' 	=> array('element' => 'custom_order', 'value' => array('1'))
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Order', 'wibar' )
			,'param_name' 	=> 'order'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Descending', 'wibar')		=> 'DESC'
				,esc_html__('Ascending', 'wibar')		=> 'ASC'
			)
			,'dependency' 	=> array('element' => 'custom_order', 'value' => array('1'))
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Columns', 'wibar' )
			,'param_name' 	=> 'columns'
			,'admin_label' 	=> true
			,'value' 		=> 5
			,'description' 	=> esc_html__( 'Number of Columns', 'wibar' )
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Limit', 'wibar' )
			,'param_name' 	=> 'per_page'
			,'admin_label' 	=> true
			,'value' 		=> 5
			,'description' 	=> esc_html__( 'Number of Products', 'wibar' )
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Product Categories', 'wibar' )
			,'param_name' 	=> 'product_cats'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'settings' => array(
				'multiple' 			=> true
				,'sortable' 		=> true
				,'unique_values' 	=> true
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Product IDs', 'wibar' )
			,'param_name' 	=> 'ids'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'settings' => array(
				'multiple' 			=> true
				,'sortable' 		=> true
				,'unique_values' 	=> true
			)
			,'description' 	=> esc_html__('Enter product name or slug to search', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Meta position', 'wibar' )
			,'param_name' 	=> 'meta_position'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Bottom', 'wibar')			=> 'bottom'
				,esc_html__('On Thumbnail', 'wibar')	=> 'on-thumbnail'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product image', 'wibar' )
			,'param_name' 	=> 'show_image'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product name', 'wibar' )
			,'param_name' 	=> 'show_title'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product SKU', 'wibar' )
			,'param_name' 	=> 'show_sku'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')	=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product price', 'wibar' )
			,'param_name' 	=> 'show_price'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product short description', 'wibar' )
			,'param_name' 	=> 'show_short_desc'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')	=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product rating', 'wibar' )
			,'param_name' 	=> 'show_rating'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product label', 'wibar' )
			,'param_name' 	=> 'show_label'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product categories', 'wibar' )
			,'param_name' 	=> 'show_categories'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')	=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show add to cart button', 'wibar' )
			,'param_name' 	=> 'show_add_to_cart'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show load more button', 'wibar' )
			,'param_name' 	=> 'show_load_more'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')	=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Load more text', 'wibar' )
			,'param_name' 	=> 'load_more_text'
			,'admin_label' 	=> true
			,'value' 		=> 'Show more'
			,'description' 	=> ''
		)
	)
) );

/*** FTC Products Slider ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Products Slider', 'wibar' ),
	'base' 		=> 'ftc_products_slider',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Block title', 'wibar' )
			,'param_name' 	=> 'title'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Product Style', 'wibar' )
			,'param_name' 	=> 'style'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Default', 'wibar')		=> ''
				,esc_html__('Version 2', 'wibar')		=> 'product-sl-v2'			
				,esc_html__('Version 3', 'wibar')		=> 'product-sl-v2 product-sl-v3'
				,esc_html__('style_1', 'wibar')	=> 'pro-home10'
				,esc_html__('style_2', 'wibar')	=> 't3'
				,esc_html__('style_3', 'wibar')	=> 't4'

			)
			,'description' 	=> esc_html__( 'Select style of product', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Product type', 'wibar' )
			,'param_name' 	=> 'product_type'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Recent', 'wibar')		=> 'recent'
				,esc_html__('Sale', 'wibar')		=> 'sale'
				,esc_html__('Featured', 'wibar')	=> 'featured'
				,esc_html__('Best Selling', 'wibar')	=> 'best_selling'
				,esc_html__('Top Rated', 'wibar')	=> 'top_rated'
				,esc_html__('Mixed Order', 'wibar')	=> 'mixed_order'
			)
			,'description' 	=> esc_html__( 'Select type of product', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Custom order', 'wibar' )
			,'param_name' 	=> 'custom_order'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('No', 'wibar')			=> 0
				,esc_html__('Yes', 'wibar')		=> 1
			)
			,'description' 	=> esc_html__( 'If you enable this option, the Product type option wont be available', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Order by', 'wibar' )
			,'param_name' 	=> 'orderby'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('None', 'wibar')				=> 'none'
				,esc_html__('ID', 'wibar')				=> 'ID'
				,esc_html__('Date', 'wibar')				=> 'date'
				,esc_html__('Name', 'wibar')				=> 'name'
				,esc_html__('Title', 'wibar')				=> 'title'
				,esc_html__('Comment count', 'wibar')		=> 'comment_count'
				,esc_html__('Random', 'wibar')			=> 'rand'
			)
			,'dependency' 	=> array('element' => 'custom_order', 'value' => array('1'))
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Order', 'wibar' )
			,'param_name' 	=> 'order'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Descending', 'wibar')		=> 'DESC'
				,esc_html__('Ascending', 'wibar')		=> 'ASC'
			)
			,'dependency' 	=> array('element' => 'custom_order', 'value' => array('1'))
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Columns', 'wibar' )
			,'param_name' 	=> 'columns'
			,'admin_label' 	=> true
			,'value' 		=> 5
			,'description' 	=> esc_html__( 'Number of Columns', 'wibar' )
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Rows', 'wibar' )
			,'param_name' 	=> 'rows'
			,'admin_label' 	=> true
			,'value' 		=> 1
			,'description' 	=> esc_html__( 'Number of Rows', 'wibar' )
		)                    
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Limit', 'wibar' )
			,'param_name' 	=> 'per_page'
			,'admin_label' 	=> true
			,'value' 		=> 6
			,'description' 	=> esc_html__( 'Number of Products', 'wibar' )
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Product Categories', 'wibar' )
			,'param_name' 	=> 'product_cats'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'settings' => array(
				'multiple' 			=> true
				,'sortable' 		=> true
				,'unique_values' 	=> true
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Meta position', 'wibar' )
			,'param_name' 	=> 'meta_position'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Bottom', 'wibar')			=> 'bottom'
				,esc_html__('On Thumbnail', 'wibar')	=> 'on-thumbnail'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product image', 'wibar' )
			,'param_name' 	=> 'show_image'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product name', 'wibar' )
			,'param_name' 	=> 'show_title'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product SKU', 'wibar' )
			,'param_name' 	=> 'show_sku'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product price', 'wibar' )
			,'param_name' 	=> 'show_price'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product short description', 'wibar' )
			,'param_name' 	=> 'show_short_desc'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product rating', 'wibar' )
			,'param_name' 	=> 'show_rating'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product label', 'wibar' )
			,'param_name' 	=> 'show_label'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product categories', 'wibar' )
			,'param_name' 	=> 'show_categories'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show add to cart button', 'wibar' )
			,'param_name' 	=> 'show_add_to_cart'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show navigation button', 'wibar' )
			,'param_name' 	=> 'show_nav'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show dots button', 'wibar' )
			,'param_name' 	=> 'dots'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Position navigation button', 'wibar' )
			,'param_name' 	=> 'position_nav'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Top', 'wibar')		=> 'nav-top'
				,esc_html__('Bottom', 'wibar')	=> 'nav-bottom'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Margin', 'wibar' )
			,'param_name' 	=> 'margin'
			,'admin_label' 	=> false
			,'value' 		=> '20'
			,'description' 	=> esc_html__('Set margin between items', 'wibar')
		)

		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Image Width Size', 'wibar' )
			,'param_name' 	=> 'custom_width'
			,'admin_label' 	=> true
			,'description' 	=> esc_html__( 'Width', 'wibar' )
		),array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Image Height Size', 'wibar' )
			,'param_name' 	=> 'custom_height'
			,'admin_label' 	=> true
			,'description' 	=> esc_html__( 'Height', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Desktop small items', 'wibar' )
			,'param_name' 	=> 'desksmall_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 991px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Tablet items', 'wibar' )
			,'param_name' 	=> 'tablet_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 768px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Tablet mini items', 'wibar' )
			,'param_name' 	=> 'tabletmini_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 640px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Mobile items', 'wibar' )
			,'param_name' 	=> 'mobile_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 480px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Mobile small items', 'wibar' )
			,'param_name' 	=> 'mobilesmall_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 0px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
	)
) );

/*** FTC Products Widget ***/
vc_map( array(
	'name' 			=> esc_html__( 'FTC Products Widget', 'wibar' ),
	'base' 			=> 'ftc_products_widget',
	'class' 		=> '',
	'description' 	=> '',
	'category' 		=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 		=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Block title', 'wibar' )
			,'param_name' 	=> 'title'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Product type', 'wibar' )
			,'param_name' 	=> 'product_type'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Recent', 'wibar')		=> 'recent'
				,esc_html__('Sale', 'wibar')		=> 'sale'
				,esc_html__('Featured', 'wibar')	=> 'featured'
				,esc_html__('Best Selling', 'wibar')	=> 'best_selling'
				,esc_html__('Top Rated', 'wibar')	=> 'top_rated'
				,esc_html__('Mixed Order', 'wibar')	=> 'mixed_order'
			)
			,'description' 	=> esc_html__( 'Select type of product', 'wibar' )
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Limit', 'wibar' )
			,'param_name' 	=> 'per_page'
			,'admin_label' 	=> true
			,'value' 		=> 6
			,'description' 	=> esc_html__( 'Number of Products', 'wibar' )
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Product Categories', 'wibar' )
			,'param_name' 	=> 'product_cats'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'settings' => array(
				'multiple' 			=> true
				,'sortable' 		=> true
				,'unique_values' 	=> true
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product image', 'wibar' )
			,'param_name' 	=> 'show_image'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Thumbnail size', 'wibar' )
			,'param_name' 	=> 'thumbnail_size'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('shop_thumbnail', 'wibar')		=> 'Product Thumbnails'
				,esc_html__('shop_catalog', 'wibar')		=> 'Catalog Images'
				,esc_html__('shop_single', 'wibar')	=> 'Single Product Image'
			)
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product name', 'wibar' )
			,'param_name' 	=> 'show_title'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product price', 'wibar' )
			,'param_name' 	=> 'show_price'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product rating', 'wibar' )
			,'param_name' 	=> 'show_rating'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product categories', 'wibar' )
			,'param_name' 	=> 'show_categories'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')	=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show in a carousel slider', 'wibar' )
			,'param_name' 	=> 'is_slider'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('No', 'wibar')	=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Row', 'wibar' )
			,'param_name' 	=> 'rows'
			,'admin_label' 	=> false
			,'value' 		=> 3
			,'description' 	=> esc_html__( 'Number of Rows for slider', 'wibar' )
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show navigation button', 'wibar' )
			,'param_name' 	=> 'show_nav'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Auto play', 'wibar' )
			,'param_name' 	=> 'auto_play'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
			,'group'		=> esc_html__('Slider Options', 'wibar')
		)
	)
) );

/*** FTC Product Deals Slider ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Product Deals Slider', 'wibar' ),
	'base' 		=> 'ftc_product_deals_slider',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Block title', 'wibar' )
			,'param_name' 	=> 'title'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Product type', 'wibar' )
			,'param_name' 	=> 'product_type'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Recent', 'wibar')		=> 'recent'
				,esc_html__('Featured', 'wibar')	=> 'featured'
				,esc_html__('Best Selling', 'wibar')	=> 'best_selling'
				,esc_html__('Top Rated', 'wibar')	=> 'top_rated'
				,esc_html__('Mixed Order', 'wibar')	=> 'mixed_order'
			)
			,'description' 	=> esc_html__( 'Select type of product', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Item Layout', 'wibar' )
			,'param_name' 	=> 'layout'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Grid', 'wibar')		=> 'grid'
				,esc_html__('List', 'wibar')		=> 'list'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Columns', 'wibar' )
			,'param_name' 	=> 'columns'
			,'admin_label' 	=> false
			,'value' 		=> 4
			,'description' 	=> esc_html__( 'Number of Columns', 'wibar' )
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Limit', 'wibar' )
			,'param_name' 	=> 'per_page'
			,'admin_label' 	=> true
			,'value' 		=> 5
			,'description' 	=> esc_html__( 'Number of Products', 'wibar' )
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Product Categories', 'wibar' )
			,'param_name' 	=> 'product_cats'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'settings' => array(
				'multiple' 			=> true
				,'sortable' 		=> true
				,'unique_values' 	=> true
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show counter', 'wibar' )
			,'param_name' 	=> 'show_counter'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Counter position', 'wibar' )
			,'param_name' 	=> 'counter_position'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Bottom', 'wibar')			=> 'bottom'
				,esc_html__('On thumbnail', 'wibar')	=> 'on-thumbnail'
			)
			,'description' 	=> ''
			,'dependency' 	=> array('element' => 'show_counter', 'value' => array('1'))
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product image', 'wibar' )
			,'param_name' 	=> 'show_image'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show gallery list', 'wibar' )
			,'param_name' 	=> 'show_gallery'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Gallery position', 'wibar' )
			,'param_name' 	=> 'gallery_position'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Bottom out line', 'wibar')	=> 'bottom-out'
				,esc_html__('Bottom in line', 'wibar')	=> 'bottom-in'
			)
			,'description' 	=> ''
			,'dependency' 	=> array('element' => 'show_counter', 'value' => array('1'))
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product name', 'wibar' )
			,'param_name' 	=> 'show_title'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product SKU', 'wibar' )
			,'param_name' 	=> 'show_sku'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product price', 'wibar' )
			,'param_name' 	=> 'show_price'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product short description', 'wibar' )
			,'param_name' 	=> 'show_short_desc'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product rating', 'wibar' )
			,'param_name' 	=> 'show_rating'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product label', 'wibar' )
			,'param_name' 	=> 'show_label'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product categories', 'wibar' )
			,'param_name' 	=> 'show_categories'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show add to cart button', 'wibar' )
			,'param_name' 	=> 'show_add_to_cart'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show navigation button', 'wibar' )
			,'param_name' 	=> 'show_nav'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show dots button', 'wibar' )
			,'param_name' 	=> 'dots'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Auto play', 'wibar' )
			,'param_name' 	=> 'auto_play'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Margin', 'wibar' )
			,'param_name' 	=> 'margin'
			,'admin_label' 	=> false
			,'value' 		=> '20'
			,'description' 	=> esc_html__('Set margin between items', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Desktop small items', 'wibar' )
			,'param_name' 	=> 'desksmall_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 991px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Tablet items', 'wibar' )
			,'param_name' 	=> 'tablet_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 768px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Tablet mini items', 'wibar' )
			,'param_name' 	=> 'tabletmini_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 640px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Mobile items', 'wibar' )
			,'param_name' 	=> 'mobile_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 480px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Mobile small items', 'wibar' )
			,'param_name' 	=> 'mobilesmall_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 0px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
	)
) );

/*** FTC Product Categories Slider ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Product Categories Slider', 'wibar' ),
	'base' 		=> 'ftc_product_categories_slider',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Block title', 'wibar' )
			,'param_name' 	=> 'title'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Columns', 'wibar' )
			,'param_name' 	=> 'columns'
			,'admin_label' 	=> true
			,'value' 		=> 4
			,'description' 	=> esc_html__( 'Number of Columns', 'wibar' )
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Rows', 'wibar' )
			,'param_name' 	=> 'rows'
			,'admin_label' 	=> true
			,'value' 		=> 1
			,'description' 	=> esc_html__( 'Number of Rows', 'wibar' )
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Limit', 'wibar' )
			,'param_name' 	=> 'per_page'
			,'admin_label' 	=> true
			,'value' 		=> 5
			,'description' 	=> esc_html__( 'Number of Product Categories', 'wibar' )
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Parent', 'wibar' )
			,'param_name' 	=> 'parent'
			,'admin_label' 	=> true
			,'settings' => array(
				'multiple' 			=> false
				,'sortable' 		=> true
				,'unique_values' 	=> true
			)
			,'value' 		=> ''
			,'description' 	=> esc_html__( 'Select a category. Get direct children of this category', 'wibar' )
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Child Of', 'wibar' )
			,'param_name' 	=> 'child_of'
			,'admin_label' 	=> true
			,'settings' => array(
				'multiple' 			=> false
				,'sortable' 		=> true
				,'unique_values' 	=> true
			)
			,'value' 		=> ''
			,'description' 	=> esc_html__( 'Select a category. Get all descendents of this category', 'wibar' )
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Product Categories', 'wibar' )
			,'param_name' 	=> 'ids'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'settings' => array(
				'multiple' 			=> true
				,'sortable' 		=> true
				,'unique_values' 	=> true
			)
			,'description' 	=> esc_html__('Include these categories', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Hide empty product categories', 'wibar' )
			,'param_name' 	=> 'hide_empty'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product category title', 'wibar' )
			,'param_name' 	=> 'show_title'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product category discription', 'wibar' )
			,'param_name' 	=> 'show_discription'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show navigation button', 'wibar' )
			,'param_name' 	=> 'show_nav'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show dots button', 'wibar' )
			,'param_name' 	=> 'dots'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Auto play', 'wibar' )
			,'param_name' 	=> 'auto_play'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Margin', 'wibar' )
			,'param_name' 	=> 'margin'
			,'admin_label' 	=> false
			,'value' 		=> '0'
			,'description' 	=> esc_html__('Set margin between items', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Desktop small items', 'wibar' )
			,'param_name' 	=> 'desksmall_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 991px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Tablet items', 'wibar' )
			,'param_name' 	=> 'tablet_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 768px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Tablet mini items', 'wibar' )
			,'param_name' 	=> 'tabletmini_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 640px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Mobile items', 'wibar' )
			,'param_name' 	=> 'mobile_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 480px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Mobile small items', 'wibar' )
			,'param_name' 	=> 'mobilesmall_items'
			,'admin_label' 	=> false
			,'value' 		=>  array(
				esc_html__('1', 'wibar')	=> 1
				,esc_html__('2', 'wibar')	=> 2
				,esc_html__('3', 'wibar')	=> 3
				,esc_html__('4', 'wibar')	=> 4
				
			)
			,'description' 	=> esc_html__('Set items on 0px', 'wibar')
			,'group'		=> esc_html__('Responsive Options', 'wibar')
		)
	)
) );


/*** FTC Products In Category Tabs***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Products Category Tabs', 'wibar' ),
	'base' 		=> 'ftc_products_category_tabs',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Product type', 'wibar' )
			,'param_name' 	=> 'product_type'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('Recent', 'wibar')		=> 'recent'
				,esc_html__('Sale', 'wibar')		=> 'sale'
				,esc_html__('Featured', 'wibar')	=> 'featured'
				,esc_html__('Best Selling', 'wibar')	=> 'best_selling'
				,esc_html__('Top Rated', 'wibar')	=> 'top_rated'
				,esc_html__('Mixed Order', 'wibar')	=> 'mixed_order'
			)
			,'description' 	=> esc_html__( 'Select type of product', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Custom order', 'wibar' )
			,'param_name' 	=> 'custom_order'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('No', 'wibar')			=> 0
				,esc_html__('Yes', 'wibar')		=> 1
			)
			,'description' 	=> esc_html__( 'If you enable this option, the Product type option wont be available', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Order by', 'wibar' )
			,'param_name' 	=> 'orderby'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('None', 'wibar')				=> 'none'
				,esc_html__('ID', 'wibar')				=> 'ID'
				,esc_html__('Date', 'wibar')				=> 'date'
				,esc_html__('Name', 'wibar')				=> 'name'
				,esc_html__('Title', 'wibar')				=> 'title'
				,esc_html__('Comment count', 'wibar')		=> 'comment_count'
				,esc_html__('Random', 'wibar')			=> 'rand'
			)
			,'dependency' 	=> array('element' => 'custom_order', 'value' => array('1'))
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Order', 'wibar' )
			,'param_name' 	=> 'order'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Descending', 'wibar')		=> 'DESC'
				,esc_html__('Ascending', 'wibar')		=> 'ASC'
			)
			,'dependency' 	=> array('element' => 'custom_order', 'value' => array('1'))
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'colorpicker'
			,'heading' 		=> esc_html__( 'Background Color', 'wibar' )
			,'param_name' 	=> 'bg_color'
			,'admin_label' 	=> false
			,'value' 		=> '#f7f6f4'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Columns', 'wibar' )
			,'param_name' 	=> 'columns'
			,'admin_label' 	=> true
			,'value' 		=> 3
			,'description' 	=> esc_html__( 'Number of Columns', 'wibar' )
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Limit', 'wibar' )
			,'param_name' 	=> 'per_page'
			,'admin_label' 	=> true
			,'value' 		=> 6
			,'description' 	=> esc_html__( 'Number of Products', 'wibar' )
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Product Categories', 'wibar' )
			,'param_name' 	=> 'product_cats'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'settings' => array(
				'multiple' 			=> true
				,'sortable' 		=> true
				,'unique_values' 	=> true
			)
			,'description' 	=> esc_html__( 'You select banners, icons in the Product Category editor', 'wibar' )
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Parent Category', 'wibar' )
			,'param_name' 	=> 'parent_cat'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'settings' => array(
				'multiple' 			=> false
				,'sortable' 		=> false
				,'unique_values' 	=> true
			)
			,'description' 	=> esc_html__('Each tab will be a sub category of this category. This option is available when the Product Categories option is empty', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Include children', 'wibar' )
			,'param_name' 	=> 'include_children'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('No', 'wibar')			=> 0
				,esc_html__('Yes', 'wibar')		=> 1
			)
			,'description' 	=> esc_html__( 'Load the products of sub categories in each tab', 'wibar' )
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Active tab', 'wibar' )
			,'param_name' 	=> 'active_tab'
			,'admin_label' 	=> false
			,'value' 		=> 1
			,'description' 	=> esc_html__( 'Enter active tab number', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product image', 'wibar' )
			,'param_name' 	=> 'show_image'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product name', 'wibar' )
			,'param_name' 	=> 'show_title'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product SKU', 'wibar' )
			,'param_name' 	=> 'show_sku'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product price', 'wibar' )
			,'param_name' 	=> 'show_price'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product short description', 'wibar' )
			,'param_name' 	=> 'show_short_desc'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product rating', 'wibar' )
			,'param_name' 	=> 'show_rating'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product label', 'wibar' )
			,'param_name' 	=> 'show_label'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show product categories', 'wibar' )
			,'param_name' 	=> 'show_categories'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show add to cart button', 'wibar' )
			,'param_name' 	=> 'show_add_to_cart'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show counter', 'wibar' )
			,'param_name' 	=> 'show_counter'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show in a carousel slider', 'wibar' )
			,'param_name' 	=> 'is_slider'
			,'admin_label' 	=> true
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Rows', 'wibar' )
			,'param_name' 	=> 'rows'
			,'admin_label' 	=> true
			,'value' 		=> array(
				'1'			=> '1'
				,'2'		=> '2'
			)
			,'description' 	=> esc_html__( 'Number of Rows in slider', 'wibar' )
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show navigation button', 'wibar' )
			,'param_name' 	=> 'show_nav'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No', 'wibar')		=> 0
				,esc_html__('Yes', 'wibar')	=> 1
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Auto play', 'wibar' )
			,'param_name' 	=> 'auto_play'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
	)
) );

/*** FTC List Of Product Categories ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC List Of Product Categories', 'wibar' ),
	'base' 		=> 'ftc_list_of_product_categories',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Block title', 'wibar' )
			,'param_name' 	=> 'title'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'attach_image'
			,'heading' 		=> esc_html__( 'Background image', 'wibar' )
			,'param_name' 	=> 'bg_image'
			,'admin_label' 	=> false
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Hover Image Effect', 'wibar' )
			,'param_name' 	=> 'style_smooth'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('No Effect', 'wibar')		=> 'no-smooth'
				,esc_html__('Effect-Image Left Right', 'wibar')		=> 'smooth-image'
				,esc_html__('Effect Border Image', 'wibar')				=> 'smooth-border-image'
				,esc_html__('Effect Background Image', 'wibar')		=> 'smooth-background-image'
				,esc_html__('Effect Background Top Image', 'wibar')	=> 'smooth-top-image'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Product Category', 'wibar' )
			,'param_name' 	=> 'product_cat'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'settings' => array(
				'multiple' 			=> false
				,'sortable' 		=> false
				,'unique_values' 	=> true
			)
			,'description' 	=> esc_html__('Display sub categories of this category', 'wibar')
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Include parent category in list', 'wibar' )
			,'param_name' 	=> 'include_parent'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Number of Sub Categories', 'wibar' )
			,'param_name' 	=> 'limit_sub_cat'
			,'admin_label' 	=> true
			,'value' 		=> 6
			,'description' 	=> esc_html__( 'Leave blank to show all', 'wibar' )
		)
		,array(
			'type' 			=> 'autocomplete'
			,'heading' 		=> esc_html__( 'Include these categories', 'wibar' )
			,'param_name' 	=> 'include_cats'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'settings' => array(
				'multiple' 			=> true
				,'sortable' 		=> true
				,'unique_values' 	=> true
			)
			,'description' 	=> esc_html__('If you set the Product Category option above, this option wont be available', 'wibar')
		)
	)
) );


/*** FTC Milestone ***/
vc_map( array(
	'name' 		=> esc_html__( 'FTC Milestone', 'wibar' ),
	'base' 		=> 'ftc_milestone',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Number', 'wibar' )
			,'param_name' 	=> 'number'
			,'admin_label' 	=> true
			,'value' 		=> '0'
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Subject', 'wibar' )
			,'param_name' 	=> 'ftc_number_meta'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Text Color Style', 'wibar' )
			,'param_name' 	=> 'text_color_style'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Default', 'wibar')	=> 'text-default'
				,esc_html__('Light', 'wibar')		=> 'text-light'
			)
			,'description' 	=> ''
		)
	)
) );
vc_map( array(
	'name' => esc_html__( 'Image Hotspot', 'wibar' ),
	'base' => 'ftc_image_hotspot',
	'class' => '',
	'category' => esc_html__( 'ThemeFTC', 'wibar' ),
	'description' => esc_html__( 'Add hotspots with products to the image', 'wibar' ),
	'icon' => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'as_parent' => array( 'only' => 'ftc_hotspot' ),
	'content_element' => true,
	'show_settings_on_create' => true,
	'params' => array(
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Image', 'wibar' ),
			'param_name' => 'img',
			'holder' => 'img',
			'value' => '',
			'description' => esc_html__( 'Select images from media library.', 'wibar' )
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Image size', 'wibar' ),
			'param_name' => 'img_size',
			'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" ', 'wibar' )
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Hotspot icon', 'wibar' ),
			'param_name' => 'icon',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Hotspot action', 'wibar' ),
			'param_name' => 'action',
			'value' =>  array(
				esc_html__( 'Hover', 'wibar' ) => 'hover',
				esc_html__( 'Click', 'wibar' ) => 'click',
			),
			'description' => esc_html__( 'Open hotspot content on click or hover', 'wibar' )
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'wibar' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'wibar' )
		)
	),
	'js_view' => 'VcColumnView'
) );
/* FTC Portfolio */
vc_map( array(
	'name' 		=> esc_html__( 'FTC Portfolio', 'wibar' ),
	'base' 		=> 'ftc_portfolio',
	'class' 	=> '',
	'category' 	=> 'ThemeFTC',
	"icon"          => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' 	=> array(
		array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Columns', 'wibar' )
			,'param_name' 	=> 'columns'
			,'admin_label' 	=> true
			,'value' 		=> array(
				'2'		=> '2'
				,'3'	=> '3'
				,'4'	=> '4'
			)
			,'description' 	=> ''
		),
		array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Portfolio Style', 'wibar' )
			,'param_name' 	=> 'style'
			,'admin_label' 	=> true
			,'value' 		=> array(
				'Default'		=> ''
				,'Version 2'	=> 'portfolio-v2'
				,'Version 3'	=> 'portfolio-v3'
			)
			,'description' 	=> 'das'
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Limit', 'wibar' )
			,'param_name' 	=> 'per_page'
			,'admin_label' 	=> true
			,'value' 		=> '8'
			,'description' 	=> esc_html__('Number of Posts', 'wibar')
		)
		,array(
			'type' 			=> 'ftc_category'
			,'heading' 		=> esc_html__( 'Categories', 'wibar' )
			,'param_name' 	=> 'categories'
			,'admin_label' 	=> true
			,'value' 		=> ''
			,'description' 	=> ''
			,'class'		=> 'ftc_portfolio'
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Order by', 'wibar' )
			,'param_name' 	=> 'orderby'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('None', 'wibar')		=> 'none'
				,esc_html__('ID', 'wibar')		=> 'ID'
				,esc_html__('Date', 'wibar')		=> 'date'
				,esc_html__('Name', 'wibar')		=> 'name'
				,esc_html__('Title', 'wibar')		=> 'title'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Order', 'wibar' )
			,'param_name' 	=> 'order'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Descending', 'wibar')		=> 'DESC'
				,esc_html__('Ascending', 'wibar')		=> 'ASC'
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show portfolio title', 'wibar' )
			,'param_name' 	=> 'show_title'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show portfolio date', 'wibar' )
			,'param_name' 	=> 'show_date'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show filter bar', 'wibar' )
			,'param_name' 	=> 'show_filter_bar'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'dropdown'
			,'heading' 		=> esc_html__( 'Show load more button', 'wibar' )
			,'param_name' 	=> 'show_load_more'
			,'admin_label' 	=> false
			,'value' 		=> array(
				esc_html__('Yes', 'wibar')	=> 1
				,esc_html__('No', 'wibar')	=> 0
			)
			,'description' 	=> ''
		)
		,array(
			'type' 			=> 'textfield'
			,'heading' 		=> esc_html__( 'Load more button text', 'wibar' )
			,'param_name' 	=> 'load_more_text'
			,'admin_label' 	=> false
			,'value' 		=> 'Load more'
			,'description' 	=> ''
		)
	)
) );

vc_map( array(
	'name' => esc_html__( 'Hotspot', 'wibar'),
	'base' => 'ftc_hotspot',
	'as_child' => array( 'only' => 'ftc_image_hotspot' ),
	'content_element' => true,
	'category' => esc_html__( 'ThemeFTC', 'wibar' ),
	'icon' => get_template_directory_uri() . "/inc/vc_extension/ftc_icon.png",
	'params' => array(
		array(
			'type' => 'ftc_image_hotspot',
			'heading' => esc_html__( 'Hotspot', 'wibar' ),
			'param_name' => 'hotspot',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Hotspot content', 'wibar' ),
			'param_name' => 'hotspot_type',
			'value' =>  array(
				esc_html__( 'Product', 'wibar' ) => 'product',
				esc_html__( 'Text', 'wibar' ) => 'text'
			),
			'description' => esc_html__( 'You can display any product or custom text in the hotspot content.', 'wibar' )
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Hotspot dropdown side', 'wibar' ),
			'param_name' => 'hotspot_dropdown_side',
			'value' =>  array(
				esc_html__( 'Left', 'wibar' ) => 'left',
				esc_html__( 'Right', 'wibar' ) => 'right',
				esc_html__( 'Top', 'wibar' ) => 'top',
				esc_html__( 'Bottom', 'wibar' ) => 'bottom',
			),
			'description' => esc_html__( 'Show the content on left or right side, top or bottom.', 'wibar' )
		),
				//Product
		array(
			'type' => 'autocomplete',
			'heading' => esc_html__( 'Select product', 'wibar' ),
			'param_name' => 'product_id',
			'description' => esc_html__( 'Add products by title.', 'wibar' ),
			'settings' => array(
				'multiple' => false,
				'sortable' => true,
				'groups' => true
			),
			'dependency' => array(
				'element' => 'hotspot_type',
				'value' => array( 'product' )
			)
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'wibar' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'wibar' )
		)
	),
) );
if( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_ftc_image_hotspot extends WPBakeryShortCodesContainer {}
}

		// Replace Wbc_Inner_Item with your base name from mapping for nested element
if( class_exists( 'WPBakeryShortCode' ) ){
	class WPBakeryShortCode_ftc_hotspot extends WPBakeryShortCode {}
}

add_filter( 'vc_autocomplete_ftc_hotspot_product_id_callback',	'ftc_productIdAutocompleteSuggester', 10, 1 ); 
add_filter( 'vc_autocomplete_ftc_image_hotspot_product_id_render','ftc_productIdAutocompleteSuggester', 10, 1 );

if ( ! function_exists( 'ftc_productIdAutocompleteSuggester' ) ) {
	function ftc_productIdAutocompleteSuggester( $query ) {
		global $wpdb;
		$product_id = (int) $query;
		$post_meta_infos = $wpdb->get_results( $wpdb->prepare( "SELECT a.ID AS id, a.post_title AS title, b.meta_value AS sku
			FROM {$wpdb->posts} AS a
			LEFT JOIN ( SELECT meta_value, post_id  FROM {$wpdb->postmeta} WHERE `meta_key` = '_sku' ) AS b ON b.post_id = a.ID
			WHERE a.post_type = 'product' AND ( a.ID = '%d' OR b.meta_value LIKE '%%%s%%' OR a.post_title LIKE '%%%s%%' )", $product_id > 0 ? $product_id : - 1, stripslashes( $query ), stripslashes( $query ) ), ARRAY_A );

		$results = array();
		if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
			foreach ( $post_meta_infos as $value ) {
				$data = array();
				$data['value'] = $value['id'];
				$data['label'] = __( 'Id', 'wibar' ) . ': ' . $value['id'] . ( ( strlen( $value['title'] ) > 0 ) ? ' - ' . __( 'Title', 'wibar' ) . ': ' . $value['title'] : '' ) . ( ( strlen( $value['sku'] ) > 0 ) ? ' - ' . __( 'Sku', 'wibar' ) . ': ' . $value['sku'] : '' );
				$results[] = $data;
			}
		}

		return $results;
	}
}

}

/*** Add Shortcode Param ***/
WpbakeryShortcodeParams::addField('ftc_category', 'wibar_product_catgories_shortcode_param');
if( !function_exists('wibar_product_catgories_shortcode_param') ){
	function wibar_product_catgories_shortcode_param($settings, $value){
		$categories = wibar_get_list_categories_shortcode_param(0, $settings);
		$arr_value = explode(',', $value);
		ob_start();
		?>
		<input type="hidden" class="wpb_vc_param_value wpb-textinput product_cats textfield ftc-hidden-selected-categories" name="<?php echo esc_attr($settings['param_name']); ?>" value="<?php echo esc_attr($value); ?>" />
		<div class="categorydiv">
			<div class="tabs-panel">
				<ul class="categorychecklist">
					<?php foreach($categories as $cat){ ?>
						<li>
							<label>
								<input type="checkbox" class="checkbox ftc-select-category" value="<?php echo esc_attr($cat->term_id); ?>" <?php echo (in_array($cat->term_id, $arr_value))?'checked':''; ?> />
								<?php echo esc_html($cat->name); ?>
							</label>
							<?php wibar_get_list_sub_categories_shortcode_param($cat->term_id, $arr_value, $settings); ?>
						</li>
					<?php } ?>
				</ul>
			</div>
		</div>
		<script type="text/javascript">
			jQuery('.ftc-select-category').on('change', function(){
				"use strict";
				
				var selected = jQuery('.ftc-select-category:checked');
				jQuery('.ftc-hidden-selected-categories').val('');
				var selected_id = new Array();
				selected.each(function(index, ele){
					selected_id.push(jQuery(ele).val());
				});
				selected_id = selected_id.join(',');
				jQuery('.ftc-hidden-selected-categories').val(selected_id);
			});
		</script>
		<?php
		return ob_get_clean();
	}
}

if( !function_exists('wibar_get_list_categories_shortcode_param') ){
	function wibar_get_list_categories_shortcode_param( $cat_parent_id, $settings ){
		$taxonomy = 'product_cat';
		if( isset($settings['class']) ){
			if( $settings['class'] == 'post_cat' ){
				$taxonomy = 'category';
			}
			if( $settings['class'] == 'ftc_testimonial' ){
				$taxonomy = 'ftc_testimonial_cat';
			}
			if( $settings['class'] == 'ftc_portfolio' ){
				$taxonomy = 'ftc_portfolio_cat';
			}
			if( $settings['class'] == 'ftc_brand' ){
				$taxonomy = 'ftc_brand_cat';
			}
		}
		
		$args = array(
			'taxonomy' 			=> $taxonomy
			,'hierarchical'		=> 1
			,'hide_empty'		=> 0
			,'parent'			=> $cat_parent_id
			,'title_li'			=> ''
			,'child_of'			=> 0
		);
		$cats = get_categories($args);
		return $cats;
	}
}

if( !function_exists('wibar_get_list_sub_categories_shortcode_param') ){
	function wibar_get_list_sub_categories_shortcode_param( $cat_parent_id, $arr_value, $settings ){
		$sub_categories = wibar_get_list_categories_shortcode_param($cat_parent_id, $settings); 
		if( count($sub_categories) > 0){
			?>
			<ul class="children">
				<?php foreach( $sub_categories as $sub_cat ){ ?>
					<li>
						<label>
							<input type="checkbox" class="checkbox ftc-select-category" value="<?php echo esc_attr($sub_cat->term_id); ?>" <?php echo (in_array($sub_cat->term_id, $arr_value))?'checked':''; ?> />
							<?php echo esc_html($sub_cat->name); ?>
						</label>
						<?php wibar_get_list_sub_categories_shortcode_param($sub_cat->term_id, $arr_value, $settings); ?>
					</li>
				<?php } ?>
			</ul>
		<?php }
	}
}

if( class_exists('Vc_Vendor_Woocommerce') ){
	$vc_woo_vendor = new Vc_Vendor_Woocommerce();

	/* autocomplete callback */
	add_filter( 'vc_autocomplete_ftc_products_ids_callback', array($vc_woo_vendor, 'productIdAutocompleteSuggester') );
	add_filter( 'vc_autocomplete_ftc_products_ids_render', array($vc_woo_vendor, 'productIdAutocompleteRender') );
	
	
	$shortcode_field_cats = array();
	$shortcode_field_cats[] = array('ftc_products', 'product_cats');
	$shortcode_field_cats[] = array('ftc_products_slider', 'product_cats');
	$shortcode_field_cats[] = array('ftc_products_widget', 'product_cats');
	$shortcode_field_cats[] = array('ftc_product_deals_slider', 'product_cats');
	$shortcode_field_cats[] = array('ftc_products_category_tabs', 'product_cats');
	$shortcode_field_cats[] = array('ftc_products_category_tabs', 'parent_cat');
	$shortcode_field_cats[] = array('ftc_list_of_product_categories', 'product_cat');
	$shortcode_field_cats[] = array('ftc_list_of_product_categories', 'include_cats');
	$shortcode_field_cats[] = array('ftc_product_categories_slider', 'parent');
	$shortcode_field_cats[] = array('ftc_product_categories_slider', 'child_of');
	$shortcode_field_cats[] = array('ftc_product_categories_slider', 'ids');
	
	foreach( $shortcode_field_cats as $shortcode_field ){
		add_filter( 'vc_autocomplete_'.$shortcode_field[0].'_'.$shortcode_field[1].'_callback', array($vc_woo_vendor, 'productCategoryCategoryAutocompleteSuggester') );
		add_filter( 'vc_autocomplete_'.$shortcode_field[0].'_'.$shortcode_field[1].'_render', array($vc_woo_vendor, 'productCategoryCategoryRenderByIdExact') );
	}
}
?>