<?php
/**
 * Additional features to allow styling of the templates
 *
 * @package WordPress
 * @subpackage Wibar
 * @since 1.0
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function wibar_body_classes( $classes ) {
	

	// Add class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Add class if we're viewing the Customizer for easier styling of theme options.
	if ( is_customize_preview() ) {
		$classes[] = 'ftc-customizer';
	}

	// Add a class if there is a custom header.
	if ( has_header_image() ) {
		$classes[] = 'has-header-image';
	}

	// Add class if sidebar is used.
	if ( is_active_sidebar( 'sidebar-1' ) && ! is_page() ) {
		$classes[] = 'has-sidebar';
	}

	

	// Add class if the site title and tagline is hidden.
	if ( 'blank' === get_header_textcolor() ) {
		$classes[] = 'title-tagline-hidden';
	}

	// Get the colorscheme or the default if there isn't one.
	$colors = wibar_sanitize_colorscheme( get_theme_mod( 'colorscheme', 'light' ) );
	$classes[] = 'colors-' . $colors;

	return $classes;
}
add_filter( 'body_class', 'wibar_body_classes' );

/**
 * Count our number of active panels.
 *
 * Primarily used to see if we have any panels active, duh.
 */
function wibar_panel_count() {

	$panel_count = 0;

	/**
	 * Filter number of front page sections in Wibar.
	 *
	 * @since Wibar 1.0
	 *
	 * @param $num_sections integer
	 */
	$num_sections = apply_filters( 'wibar_front_page_sections', 4 );

	// Create a setting and control for each of the sections available in the theme.
	for ( $i = 1; $i < ( 1 + $num_sections ); $i++ ) {
		if ( get_theme_mod( 'panel_' . $i ) ) {
			$panel_count++;
		}
	}

	return $panel_count;
}

/**
 * Checks to see if we're on the homepage or not.
 */
function wibar_is_frontpage() {
	return ( is_front_page() && ! is_home() );
}
/*** Vertical Menu Heading ***/
if( !function_exists ('wibar_get_vertical_menu_heading') ){
	function wibar_get_vertical_menu_heading(){
		$locations = get_nav_menu_locations();
		if( isset($locations['vertical']) ){
			$menu = wp_get_nav_menu_object($locations['vertical']);
			if( isset( $menu->name ) ){
				return $menu->name;
			}
			else{
				return esc_html__('Shop by category', 'wibar');
			}
		}
		return '';
	}
}

/* function to display number of posts. */
function get_post_views($postID){
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0";
    }
    return $count;
}

/* function to count views. */
function set_post_views($postID) {
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}

/* Is Active Mega Main Menu */
if( !function_exists('wibar_has_megamainmenu') ){
	function wibar_has_megamainmenu(){
		$_actived = apply_filters('active_plugins', get_option('active_plugins'));
		if( in_array("mega_main_menu/mega_main_menu.php", $_actived) ){
			return true;
		}
		return false;
	}
}
/* Change footer for the individual page */
if( !class_exists('ThemeFtc_GET') ){
	add_filter('widget_display_callback', 'wibar_change_footer_for_individual_page', 10, 3);
	function wibar_change_footer_for_individual_page( $instance, $object, $args ){
		global $post;
		if( is_page() && ($args['name'] == esc_html__('Footer Top', 'wibar') || $args['name'] == esc_html__('Footer Bottom', 'wibar') || $args['name'] == esc_html__('Footer Middle', 'wibar'))
			&& get_class($object) == 'Ftc_Footer_Widget' ) 
			{
			if( $args['name'] == esc_html__('Footer Top', 'wibar') ){
				$block_id = get_post_meta($post->ID, 'ftc_footer_top', true);
			}
			elseif( $args['name'] == esc_html__('Footer Bottom', 'wibar') ){
				$block_id = get_post_meta($post->ID, 'ftc_footer_bottom', true);
			}
			else{
				$block_id = get_post_meta($post->ID, 'ftc_footer_middle', true);
			}
			if( $block_id ){
				$instance['block_id'] = $block_id;
			}
		}
		return $instance;
	}
}