<?php 
global $wibar_default_sidebars, $wibar_default_widgetareas;

$wibar_default_sidebars = array(
	array(
		'name' => esc_html__( 'Home Sidebar', 'wibar' ),
		'id' => 'home-sidebar',
		'description' => esc_html__( 'Add widgets here to appear in your page.', 'wibar' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<div class="widget-title-wrapper"><a class="block-control" href="javascript:void(0)"></a><h3 class="widget-title product_title">',
		'after_title' => '</h3></div>',
		)
	,array(
		'name' => esc_html__( 'Blog Sidebar', 'wibar' ),
		'id' => 'blog-sidebar',
		'description' => esc_html__( 'Add widgets here to appear in your Blog page.', 'wibar' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<div class="widget-title-wrapper"><a class="block-control" href="javascript:void(0)"></a><h3 class="widget-title product_title">',
		'after_title' => '</h3></div>',
		)
	,array(
		'name' => esc_html__( 'Blog Detail Sidebar', 'wibar' ),
		'id' => 'blog-detail-sidebar',
		'description' => esc_html__( 'Add widgets here to appear in your Blog detail page.', 'wibar' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<div class="widget-title-wrapper"><a class="block-control" href="javascript:void(0)"></a><h3 class="widget-title product_title">',
		'after_title' => '</h3></div>',
		)
	,array(
		'name' => esc_html__( 'Product Category Sidebar', 'wibar' ),
		'id' => 'product-category-sidebar',
		'description' => esc_html__( 'Add widgets here to appear in your Product Category page.', 'wibar' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<div class="widget-title-wrapper"><a class="block-control" href="javascript:void(0)"></a><h3 class="widget-title product_title">',
		'after_title' => '</h3></div>',
		)
	,array(
		'name' => esc_html__( 'Product Category Top Content', 'wibar' ),
		'id' => 'product-category-top-content',
		'description' => esc_html__( 'Add widgets here to appear in your Fillter Product Category page.', 'wibar' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<div class="widget-title-wrapper"><a class="block-control" href="javascript:void(0)"></a><h3 class="widget-title product_title">',
		'after_title' => '</h3></div>',
		)
	,array(
		'name' => esc_html__( 'Product Detail Sidebar', 'wibar' ),
		'id' => 'product-detail-sidebar',
		'description' => esc_html__( 'Add widgets here to appear in your Product Detail page.', 'wibar' ),
		'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<div class="widget-title-wrapper"><a class="block-control" href="javascript:void(0)"></a><h3 class="widget-title product_title">',
		'after_title' => '</h3></div>',
		)
	,array(
		'name'          => esc_html__( 'Product Detail Social Icon', 'wibar' ),
		'id'            => 'product-detail-social-icon',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'description'   => esc_html__( 'Add social icon in your product detail page.', 'wibar' ),
		)
	,array(
		'name'          => esc_html__( 'Popup Newletter', 'wibar' ),
		'id'            => 'popup-newletter',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'description'   => '',
		)
	,array(
		
		'name'  => esc_html__( 'List Categories Breadcrumbs', 'wibar' ),
		'id'            => 'list-categories-breadcrumbs',

		'before_widget' => '<div id="%1$s" class="widget %2$s">',

		'after_widget' => '</div>',
		'description'   => '',

	)
	);

$wibar_default_widgetareas = array(
	array(
		'name'          => esc_html__( 'Footer Top', 'wibar' ),
		'id'            => 'footer-top',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'wibar' ),
		)
	,array(
		'name'          => esc_html__( 'Footer Middle', 'wibar' ),
		'id'            => 'footer-middle',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'wibar' ),
		)
	,array(
		'name'          => esc_html__( 'Footer Bottom', 'wibar' ),
		'id'            => 'footer-bottom',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'wibar' ),
		)
	);

$custom_sidebars = ftc_get_custom_sidebars();
if( is_array($custom_sidebars) && !empty($custom_sidebars) ){
	foreach( $custom_sidebars as $name ){
		$wibar_default_sidebars[] = array(
			'name' => ''.$name.'',
			'id' => sanitize_title($name),
			'description' => '',
			'class'			=> 'ftc-custom-sidebar',
			'before_widget' => '<section id="%1$s" class="widget-container %2$s">',
			'after_widget' => '</section>',
			'before_title' => '<div class="widget-title-wrapper"><a class="block-control" href="javascript:void(0)"></a><h3 class="widget-title product_title">',
			'after_title' => '</h3></div>',
			);
	}
}

function wibar_register_widget_area(){
	global $wibar_default_sidebars, $wibar_default_widgetareas;
	$default_sidebar = array_merge($wibar_default_sidebars, $wibar_default_widgetareas);
	foreach( $default_sidebar as $sidebar ){
		register_sidebar($sidebar);
	}
}
add_action( 'widgets_init', 'wibar_register_widget_area' );
?>