<?php
$options = array();
global $wibar_default_sidebars;
$sidebar_options = array();
foreach( $wibar_default_sidebars as $key => $_sidebar ){
	$sidebar_options[$_sidebar['id']] = $_sidebar['name'];
}

/* Get list menus */
$menus = array('0' => esc_html__('Default', 'wibar'));
$nav_terms = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
if( is_array($nav_terms) ){
	foreach( $nav_terms as $term ){
		$menus[$term->term_id] = $term->name;
	}
}

$options[] = array(
	'id'		=> 'page_layout_heading'
	,'label'	=> esc_html__('Page Layout', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'heading'
);

$options[] = array(
	'id'		=> 'layout_style'
	,'label'	=> esc_html__('Layout Style', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> array(
		'default'  	=> esc_html__('Default', 'wibar')
		,'boxed' 	=> esc_html__('Boxed', 'wibar')
		,'wide' 	=> esc_html__('Wide', 'wibar')
	)
);

$options[] = array(
	'id'		=> 'page_layout'
	,'label'	=> esc_html__('Page Layout', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> array(
		'0-1-0'  => esc_html__('Fullwidth', 'wibar')
		,'1-1-0' => esc_html__('Left Sidebar', 'wibar')
		,'0-1-1' => esc_html__('Right Sidebar', 'wibar')
		,'1-1-1' => esc_html__('Left & Right Sidebar', 'wibar')
	)
);

$options[] = array(
	'id'		=> 'left_sidebar'
	,'label'	=> esc_html__('Left Sidebar', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> $sidebar_options
);

$options[] = array(
	'id'		=> 'right_sidebar'
	,'label'	=> esc_html__('Right Sidebar', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> $sidebar_options
);

$options[] = array(
	'id'		=> 'left_right_padding'
	,'label'	=> esc_html__('Left Right Padding', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> array(
		'1'		=> esc_html__('Yes', 'wibar')
		,'0'	=> esc_html__('No', 'wibar')
	)
	,'default'	=> '0'
);

$options[] = array(
	'id'		=> 'full_page'
	,'label'	=> esc_html__('Full Page', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> array(
		'1'		=> esc_html__('Yes', 'wibar')
		,'0'	=> esc_html__('No', 'wibar')
	)
	,'default'	=> '0'
);

$options[] = array(
	'id'		=> 'header_breadcrumb_heading'
	,'label'	=> esc_html__('Header - Breadcrumb', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'heading'
);

$options[] = array(
	'id'		=> 'header_layout'
	,'label'	=> esc_html__('Header Layout', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> array(
		'default'  	=> esc_html__('Default', 'wibar')
		,'layout2' 		=> esc_html__('Header Layout 2', 'wibar')
		,'layout3' 		=> esc_html__('Header Layout 3', 'wibar')
		,'layout4' 		=> esc_html__('Header Layout 4', 'wibar')
		,'layout5' 		=> esc_html__('Header Layout 5', 'wibar')
		,'layout6' 		=> esc_html__('Header Layout 6', 'wibar')
		,'layout7' 		=> esc_html__('Header Layout 7', 'wibar')
		,'layout8' 		=> esc_html__('Header Layout 8', 'wibar')
		,'layout9' 		=> esc_html__('Header Layout 9', 'wibar')
		,'layout10'		=> esc_html__('Header Layout 10','wibar')
		,'layout11'		=> esc_html__('Header Layout 11','wibar')
		,'layout12'		=> esc_html__('Header Layout 12','wibar')
		,'layout13'		=> esc_html__('Header Layout 13','wibar')
		,'layout14'		=> esc_html__('Header Layout 14','wibar')
		,'layout15'		=> esc_html__('Header 1 absolute','wibar')
		
	)
);

$options[] = array(
	'id'		=> 'header_transparent'
	,'label'	=> esc_html__('Transparent Header', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> array(
		'1'		=> esc_html__('Yes', 'wibar')
		,'0'	=> esc_html__('No', 'wibar')
	)
	,'default'	=> '0'
);

$options[] = array(
	'id'		=> 'header_text_color'
	,'label'	=> esc_html__('Header Text Color', 'wibar')
	,'desc'		=> esc_html__('Only available on transparent header', 'wibar')
	,'type'		=> 'select'
	,'options'	=> array(
		'default'	=> esc_html__('Default', 'wibar')
		,'light'	=> esc_html__('Light', 'wibar')
	)
);

$options[] = array(
	'id'		=> 'menu_id'
	,'label'	=> esc_html__('Primary Menu', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> $menus
);

$options[] = array(
	'id'		=> 'show_page_title'
	,'label'	=> esc_html__('Show Page Title', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> array(
		'1'		=> esc_html__('Yes', 'wibar')
		,'0'	=> esc_html__('No', 'wibar')
	)
);

$options[] = array(
	'id'		=> 'show_breadcrumb'
	,'label'	=> esc_html__('Show Breadcrumb', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> array(
		'1'		=> esc_html__('Yes', 'wibar')
		,'0'	=> esc_html__('No', 'wibar')
	)
);

$options[] = array(
	'id'		=> 'breadcrumb_layout'
	,'label'	=> esc_html__('Breadcrumb Layout', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> array(
		'default'  	=> esc_html__('Default', 'wibar')
		,'v1'  		=> esc_html__('Breadcrumb Layout 1', 'wibar')
		,'v2' 		=> esc_html__('Breadcrumb Layout 2', 'wibar')
		,'v3' 		=> esc_html__('Breadcrumb Layout 3', 'wibar')
	)
);

$options[] = array(
	'id'		=> 'breadcrumb_bg_parallax'
	,'label'	=> esc_html__('Breadcrumb Background Parallax', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'select'
	,'options'	=> array(
		'default'  	=> esc_html__('Default', 'wibar')
		,'1'		=> esc_html__('Yes', 'wibar')
		,'0'		=> esc_html__('No', 'wibar')
	)
);

$options[] = array(
	'id'		=> 'bg_breadcrumbs'
	,'label'	=> esc_html__('Breadcrumb Background Image', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'upload'
);	

$options[] = array(
	'id'		=> 'logo'
	,'label'	=> esc_html__('Logo', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'upload'
);

$options[] = array(
	'id'		=> 'logo_mobile'
	,'label'	=> esc_html__('Mobile Logo', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'upload'
);

$options[] = array(
	'id'		=> 'primary_color'
	,'label'	=> esc_html__('Primary Color', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'colorpicker'
);

$options[] = array(
	'id'		=> 'secondary_color'
	,'label'	=> esc_html__('Secondary Color', 'wibar')
	,'desc'		=> ''
	,'type'		=> 'colorpicker'
);


$options[] = array(
	'id'	=>'body_font_google'
	,'label' => esc_html__('Body Font - Google Font', 'wibar')
	,'desc'	=> ''
	,'type' => 'text'
);

$options[] = array(
	'id'	=>'secondary_body_font_google'
	,'label' => esc_html__('Secondary Body Font - Google Font', 'wibar')
	,'desc'	=> ''
	,'type' => 'text'
);
$options[] = array(
	'id' => 'page_enable_popup'
	,'label' => esc_html__('Show popup newletter on page', 'wibar')
	,'desc' => ''
	,'type' => 'select'
	,'default' => 0
	,'options' => array(
		'0' => esc_html__('No', 'wibar')
		,'1' => esc_html__('Yes', 'wibar')
	)
);

if( !class_exists('ThemeFtc_GET') ){			
	$footer_blocks = array('0' => '');
	
	$args = array(
		'post_type'			=> 'ftc_footer'
		,'post_status'	 	=> 'publish'
		,'posts_per_page' 	=> -1
	);
	
	$posts = new WP_Query($args);
	
	if( !empty( $posts->posts ) && is_array( $posts->posts ) ){
		foreach( $posts->posts as $p ){
			$footer_blocks[$p->ID] = $p->post_title;
		}
	}

	$options[] = array(
		'id'		=> 'page_footer_heading'
		,'label'	=> 'Page Footer'
		,'desc'		=> esc_html__('You also need to add the FTC- Footer widget into Footer Top,Middle,Bottom', 'wibar')
		,'type'		=> 'heading'
	);

	$options[] = array(
		'id'		=> 'footer_top'
		,'label'	=> esc_html__('Footer Top', 'wibar')
		,'desc'		=> ''
		,'type'		=> 'select'
		,'options'	=> $footer_blocks
	);

	$options[] = array(
		'id'		=> 'footer_middle'
		,'label'	=> esc_html__('Footer Middle', 'wibar')
		,'desc'		=> ''
		,'type'		=> 'select'
		,'options'	=> $footer_blocks
	);

	$options[] = array(
		'id'		=> 'footer_bottom'
		,'label'	=> esc_html__('Footer Bottom', 'wibar')
		,'desc'		=> ''
		,'type'		=> 'select'
		,'options'	=> $footer_blocks
	);

}

?>