<?php
/**
* The header for our theme
*
* This is the template that displays all of the <head> section and everything up until <div id="content">
*
* @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
*
* @package WordPress
* @subpackage Wibar
* @since 1.0
* @version 1.0
*/

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
    <?php global $smof_data; ?>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <?php 
    wibar_theme_favicon();
    wp_head(); 
    ?>
</head>

<body <?php body_class(); ?>>
    <?php wibar_header_mobile_navigation(); ?>
    <div id="page" class="site">
        <a class="skip-link screen-reader-text" href="#content"></a>

        <header id="masthead" class="site-header">
            <div class="header-ftc header-<?php echo esc_attr($smof_data['ftc_header_layout']); ?>">
                <div class="button-tick" title="Click show header ">
                    <i class="icon-arrow-down"></i>
                </div>

                <div class="header-content">
                    <!-- <div class="container"> -->
                        <div class="mobile-button">
                            <div class="mobile-nav">
                                <i class="fa fa-bars"></i>
                            </div>
                        </div>
                        <div class="logo-wrapper is-desktop"><?php wibar_theme_logo(); ?></div>
                        <div class="logo-wrapper is-mobile"><?php ftc_theme_mobile_logo(); ?></div>   
                        <?php if ( has_nav_menu( 'primary' ) ) : ?>
                            <div class="navigation-primary">

                                <?php get_template_part( 'template-parts/navigation/navigation', 'primary' ); ?>

                            </div>
                        <?php endif; ?>
                        <div class="search-cart">
                            <?php if(isset($smof_data['ftc_enable_search']) &&  $smof_data['ftc_enable_search'] ): ?>
                                <div class="ftc-search-product"><?php wibar_get_search_form_by_category(); ?></div>
                            <?php endif; ?>

                            <?php if( isset($smof_data['ftc_enable_tiny_shopping_cart']) && $smof_data['ftc_enable_tiny_shopping_cart'] ): ?>
                                <div class="ftc-shop-cart"><?php echo wp_kses_post(wibar_tiny_cart()); ?></div>
                            <?php endif; ?>
                            <div class="toggle-menu">
                              <div class="mobile-nav-desk"> <i class="fa fa-bars"></i></div>
                              <div class="content-toggle" style="display:none">
                                <?php if( isset($smof_data['ftc_header_language']) && $smof_data['ftc_header_language'] ): ?>
                                    <div class="ftc-sb-language"><?php wibar_wpml_language_selector(); ?></div>
                                <?php endif; ?>
                                <?php if( isset($smof_data['ftc_header_currency']) && $smof_data['ftc_header_currency'] ): ?>
                                    <div class="header-currency"><?php wibar_woocommerce_multilingual_currency_switcher(); ?></div>
                                <?php endif; ?>
                                <?php if( isset($smof_data['ftc_enable_tiny_account']) && $smof_data['ftc_enable_tiny_account'] ): ?>
                                    <div class="ftc-sb-account"><?php print_r(wibar_tiny_account()) ; ?></div>
                                <?php endif; ?>
                                <?php if( class_exists('YITH_WCWL') && isset($smof_data['ftc_enable_tiny_wishlist']) && $smof_data['ftc_enable_tiny_wishlist'] ): ?>
                                <div class="ftc-my-wishlist"><?php echo wp_kses_post(wibar_tini_wishlist()); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                </div>
                <?php if( isset($smof_data['ftc_content_social_icon']) && $smof_data['ftc_content_social_icon'] ): ?>
                    <div class="social-icons menu-icon">
                        <?php echo wp_kses_post(do_shortcode(stripslashes($smof_data['ftc_content_social_icon']))); ?></div>
                    <?php endif; ?>

                    <!-- </div> -->
                </div>
            </div>
        </header><!-- #masthead -->

        <div class="site-content-contain">
            <div id="content" class="site-content">
