<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Wibar
 * @since 1.0
 * @version 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<?php global $smof_data; ?>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <?php 
    wibar_theme_favicon();
    wp_head(); 
    ?>
</head>

<body <?php body_class(); ?>>
    <?php wibar_header_mobile_navigation(); ?>
    <div id="page" class="site">
     <a class="skip-link screen-reader-text" href="#content"></a>

     <header id="masthead" class="site-header">

        <div class="header-ftc header-<?php echo esc_attr($smof_data['ftc_header_layout']); ?>">

            <div class="header-content">
                <div class="container">
                    <div class="mobile-button">
                        <div class="mobile-nav">
                            <i class="fa fa-bars"></i>
                        </div>
                    </div>
                    <div class="logo-wrapper is-desktop"><?php wibar_theme_logo(); ?></div>
                    <div class="logo-wrapper is-mobile"><?php ftc_theme_mobile_logo(); ?></div>   
                    <?php if ( has_nav_menu( 'primary' ) ) : ?>
                      <div class="navigation-primary">
                         <div class="container">
                            <?php get_template_part( 'template-parts/navigation/navigation', 'primary' ); ?>
                        </div><!-- .container -->
                    </div><!-- .navigation-top -->
                <?php endif; ?>
                <div class="search-cart">
                    <?php if( isset($smof_data['ftc_enable_search']) && $smof_data['ftc_enable_search'] ): ?>
                        <div class="ftc-search-product"><?php wibar_get_search_form_by_category(); ?></div>
                    <?php endif; ?>
                    
                    <?php if( isset($smof_data['ftc_enable_tiny_shopping_cart']) && $smof_data['ftc_enable_tiny_shopping_cart'] ): ?>
                        <div class="ftc-shop-cart"><?php echo wp_kses_post(wibar_tiny_cart_v3()); ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

    </div>
</header><!-- #masthead -->

<div class="site-content-contain">
  <div id="content" class="site-content">
