<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Wibar
 * @since 1.0
 * @version 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
    <?php global $smof_data; ?>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <?php 
    wibar_theme_favicon();
    wp_head(); 
    ?>
</head>
<?php
$header_classes = array();
if( isset($smof_data['ftc_enable_sticky_header']) && $smof_data['ftc_enable_sticky_header'] ){
  $header_classes[] = 'header-sticky';
}
?>
<body <?php body_class(); ?>>
    <?php wibar_header_mobile_navigation(); ?>
    <div id="page" class="site">
     <a class="skip-link screen-reader-text" href="#content"></a>

     <header id="masthead" class="site-header">
        <div class="header-ftc header-<?php echo esc_attr($smof_data['ftc_header_layout']); ?>">
            <div class="container">
                <div class="close-home12";><i class="fa fa-chevron-circle-down" aria-hidden="true"></i>
                </div>
                <div class="header-content " >
                    <div class="mobile-button">
                        <div class="mobile-nav">
                            <i class="fa fa-bars"></i>
                        </div>
                    </div>
                    <div class="logo-wrapper is-desktop"><?php wibar_theme_logo(); ?></div>
                    <div class="logo-wrapper is-mobile"><?php ftc_theme_mobile_logo(); ?></div>   
                    <div class="search-cart">
                      <div class="toggle-menu">
                          <div class="mobile-nav-desk"> <i class="fa fa-bars"></i></div>
                          <div class="content-toggle" style="display:none">
                            <?php if( isset($smof_data['ftc_header_language']) && $smof_data['ftc_header_language'] ): ?>
                                <div class="ftc-sb-language"><?php wibar_wpml_language_selector(); ?></div>
                            <?php endif; ?>
                            <?php if( isset($smof_data['ftc_header_currency']) && $smof_data['ftc_header_currency'] ): ?>
                                <div class="header-currency"><?php wibar_woocommerce_multilingual_currency_switcher(); ?></div>
                            <?php endif; ?>
                            <?php if( isset($smof_data['ftc_enable_tiny_account']) && $smof_data['ftc_enable_tiny_account'] ): ?>
                                <div class="ftc-sb-account"><?php print_r(wibar_tiny_account()) ; ?></div>
                            <?php endif; ?>
                            <?php if( class_exists('YITH_WCWL') && isset($smof_data['ftc_enable_tiny_wishlist']) && $smof_data['ftc_enable_tiny_wishlist'] ): ?>
                            <div class="ftc-my-wishlist"><?php echo wp_kses_post(wibar_tini_wishlist()); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if( isset($smof_data['ftc_enable_tiny_shopping_cart']) && $smof_data['ftc_enable_tiny_shopping_cart'] ): ?>
                    <div class="ftc-shop-cart"><?php echo wp_kses_post(wibar_tiny_cart()); ?></div>
                <?php endif; ?>

                <?php if( isset($smof_data['ftc_enable_search']) && $smof_data['ftc_enable_search'] ): ?>
                    <div class="ftc-search-product"><?php wibar_get_search_form_by_category(); ?></div>
                <?php endif; ?>
            </div>
            <?php if ( has_nav_menu( 'primary' ) ) : ?>
                <div class="navigation-primary">
                    <div>
                        <?php get_template_part( 'template-parts/navigation/navigation', 'primary' ); ?>
                    </div><!-- .container -->
                </div><!-- .navigation-top -->
            <?php endif; ?>
            <div class="social-icons menu-icon">
                <ul class="list-icons">
                    <li><a class="twitter" title="#" href="http://twitter.com/#" target="_blank" rel="noopener noreferrer"><i class="fa fa-twitter"></i></a></li>
                    <li><a class="google-plus" title="#" href="https://plus.google.com/#" target="_blank" rel="noopener noreferrer"><i class="fa fa-google-plus"></i></a></li>
                    <li><a class="youtube" title="#" href="https://www.youtube.com/user/#" target="_blank" rel="noopener noreferrer"><i class="fa fa-youtube-square"></i></a></li>
                    <li><a class="instagram" title="#" href="https://instagram.com/#" target="_blank" rel="noopener noreferrer"><i class="fa fa-instagram"></i></a></li>
                </ul>
            </div>
            
        </div>
        <div>
        </div>
    </header><!-- #masthead -->

    <div class="site-content-contain">
      <div id="content" class="site-content">
