<?php
/*
Plugin Name: Courier Manager
Plugin URI: https://app.couriermanager.eu/
Description: Courier Manager delivery module
Version: 1.1
Author: Alex Stoica
Author URI: https://devgeeks.ro
*/

#error_reporting(E_ALL);
#ini_set('display_errors', 1);

function isWoocommerceActive()
{
    $plugins = array();

    // Check if is multisite
    if (defined('MULTISITE') && MULTISITE == true) {
        $plugins = array_keys(get_site_option('active_sitewide_plugins'));
    }

    // Add website plugins
    $plugins = array_merge($plugins, apply_filters('active_plugins', get_option('active_plugins')));

    if (in_array('woocommerce/woocommerce.php', $plugins)) {
        return true;
    }
    return false;
}

/**
 * Check if WooCommerce is active
 */

if (isWoocommerceActive()) {
    require_once (__dir__ . "/CourierManagerApi.php");

    /**
     * Shipping method init
     */
    function couriermanager_shipping_method_init() {
        if ( ! class_exists( 'WC_CourierManager_Shipping_Method' ) ) {
            require_once (__dir__ . "/ShippingMethod.php");
        }
    }
    add_action( 'woocommerce_shipping_init', 'couriermanager_shipping_method_init' );

    /**
     * Add shipping method to cart
     * @param $methods
     * @return mixed
     */
    function add_couriermanager_shipping_method( $methods ) {
        $methods['couriermanager_shipping_method'] = 'WC_CourierManager_Shipping_Method';
        return $methods;
    }
    add_filter( 'woocommerce_shipping_methods', 'add_couriermanager_shipping_method' );


    /**
     * @param $order_id
     */
    function finish_couriermanager_order($order_id) {
        require_once (__dir__ . "/CreateAwb.php");
        new CreateAwb(new WC_Order($order_id));
    }
    add_filter( 'woocommerce_checkout_order_processed', 'finish_couriermanager_order',  1, 1 );
}