<?php

class CreateAwb
{
    const DEFAULT_COUNTRY = "Romania";
    const DEFAULT_COUNTY = "Bucuresti";

    /** @var CourierManagerApi */
    protected $apiClient;

    /** @var WC_Order */
    private  $order;

    /** @var WC_CourierManager_Shipping_Method */
    private $shippingMethod;

    /**
     * Constructor for your shipping class
     *
     * @access public
     * @param WC_Order $order
     */
    public function __construct($order)
    {
        $this->order = $order;
        $this->apiClient = new CourierManagerApi($this->get_option('cm_api_url'), $this->get_option('cm_api_key'));
        $this->create();
    }

    private function create()
    {
        /** Call API */
        $deliveryData = $this->getDeliveryData();
        $apiResponse = $this->apiClient->createAwb($deliveryData);
        if (isset($apiResponse->status) && $apiResponse->status == "done" && isset($apiResponse->data->no)) {
            $this->order->add_order_note("AWB {$apiResponse->data->no}");
            $this->order->save();
        }

    }

    /**
     * @return array
     */
    private function getDeliveryData()
    {
        // County/State
        $countryStates = WC()->countries->get_shipping_country_states();
        $countries = WC()->countries->get_shipping_countries();
        $countryId = $this->order->get_shipping_country();
        $stateId = $this->order->get_shipping_state();

        // Get Country
        $countryName = self::DEFAULT_COUNTRY;
        if (!empty($countries[$countryId])) {
            $countryName = $countries[$countryId];
        }

        // Get County
        $countyName = self::DEFAULT_COUNTY;
        if (!empty($countryStates[$countryId][$stateId])) {
            $countyName = $countryStates[$countryId][$stateId];
        }

        // Address
        $address = $this->order->get_shipping_address_1();
        if ($this->order->get_shipping_address_2() != "") {
            $address.= ", " . $this->order->get_shipping_address_2();
        }

        // Get name
        $name = $this->order->get_shipping_first_name() . " " . $this->order->get_shipping_last_name();

        // API call data
        $deliveryData = array(
            "use_default_from_address" => "true",
            "type" => $this->get_option('cm_packaging_type'),
            "service_type" => $this->get_option('cm_delivery_type_code'),
            "cnt" => 1, //WC()->cart->get_cart_contents_count(),
            "weight" => WC()->cart->get_cart_contents_weight(),
            "to_name" => $name,
            "to_contact" => $name,
            "to_phone" => $this->order->get_billing_phone(),
            "to_email" => $this->order->get_billing_email(),
            "to_country" => html_entity_decode($countryName),
            "to_county" => html_entity_decode($countyName),
            "to_city" =>  $this->order->get_shipping_city(),
            "to_address" => $address,
            "to_zipcode" => $this->order->get_shipping_postcode()
        );

        // Add cash on delivery
        if ($this->order->get_payment_method() == "cod") {
            if ($this->get_option('cm_payment_awb') == 1) {
                $deliveryData["ramburs"] = $this->order->get_subtotal();
            }else{
                $deliveryData["ramburs"] = $this->order->get_total();
            }

            $deliveryData["ramburs_type"] = $this->get_option('cm_cod_type');
        }

        return $deliveryData;
    }

    /**
     * @param $key
     * @return mixed|null
     */
    private function get_option($key)
    {
        if (!$this->shippingMethod) {
            $this->shippingMethod = $this->getShippingMethod();
        }

        if (!$this->shippingMethod instanceof WC_CourierManager_Shipping_Method) {
            return null;
        }

        return $this->shippingMethod->get_option($key);
    }

    /**
     * @return bool|WC_Shipping_Method
     */
    private function getShippingMethod()
    {
        $shipping_method_id = null;
        foreach ($this->order->get_shipping_methods() as $shipping_method ) {
            $shipping_method_id = $shipping_method->get_method_id();
        }

        $shipping_methods = WC_Shipping::instance()->get_shipping_methods();
        if (!isset($shipping_methods[$shipping_method_id])) {
            return false;
        }

        return $shipping_methods[$shipping_method_id];
    }
}
