<?php

class CourierManagerApi
{
    const CREATE_AWB_ENDPOINT = "create_awb";
    const PRICE_AWB_ENDPOINT = "get_price";
    const PRINT_AWB_ENDPOINT = "print";
    const INFO_AWB_ENDPOINT = "get_info";

    private $apiUrl;
    private $apiKey;

    public function __construct($apiUrl, $apiKey)
    {
        $this->apiUrl = $apiUrl;
        $this->apiKey = $apiKey;
    }

    public function createAwb($data)
    {
        $response = $this->callApi(self::CREATE_AWB_ENDPOINT, $data);
        return json_decode($response);
    }

    public function priceAwb($data)
    {
        $response = $this->callApi(self::PRICE_AWB_ENDPOINT, $data);
        return json_decode($response);
    }

    public function printAwb($awbId)
    {
        return $this->callApi(self::PRINT_AWB_ENDPOINT, array(
            "awbno" => $awbId,
            "pdf" => true
        ));
    }

    public function infoAwb($awbId)
    {
        $response = $this->callApi(self::INFO_AWB_ENDPOINT, array(
            "awbno" => $awbId
        ));
        return json_decode($response);
    }

    private function callApi($endpoint, $params = array())
    {
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_URL, $this->apiUrl . "/API/" . $endpoint . "?api_key=" . $this->apiKey);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        if (!empty($params)) {
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($params));
        }

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            error_log($err);
            return false;
        }

        return $response;
    }
}
